"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimesliderControlFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _presentationContainers = require("@kbn/presentation-containers");
var _controlsConstants = require("@kbn/controls-constants");
var _default_control_manager = require("../default_control_manager");
var _time_slider_popover_button = require("./components/time_slider_popover_button");
var _time_slider_popover_content = require("./components/time_slider_popover_content");
var _time_slider_prepend = require("./components/time_slider_prepend");
var _init_time_range_percentage = require("./init_time_range_percentage");
var _init_time_range_subscription = require("./init_time_range_subscription");
var _time_utils = require("./time_utils");
var _is_compressed = require("../../control_group/utils/is_compressed");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/controls/public/controls/timeslider_control/get_timeslider_control_factory.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const displayName = _i18n.i18n.translate('controls.timesliderControl.displayName', {
  defaultMessage: 'Time slider'
});
const getTimesliderControlFactory = () => {
  return {
    type: _controlsConstants.TIME_SLIDER_CONTROL,
    getIconType: () => 'search',
    getDisplayName: () => displayName,
    buildControl: async ({
      initialState,
      finalizeApi,
      uuid,
      controlGroupApi
    }) => {
      var _getViewModeSubject;
      const {
        timeRangeMeta$,
        formatDate,
        cleanupTimeRangeSubscription
      } = (0, _init_time_range_subscription.initTimeRangeSubscription)(controlGroupApi);
      const timeslice$ = new _rxjs.BehaviorSubject(undefined);
      const isAnchored$ = new _rxjs.BehaviorSubject(initialState.isAnchored);
      const isPopoverOpen$ = new _rxjs.BehaviorSubject(false);
      const hasTimeSliceSelection$ = new _rxjs.BehaviorSubject(Boolean(timeslice$));
      const timeRangePercentage = (0, _init_time_range_percentage.initTimeRangePercentage)(initialState, syncTimesliceWithTimeRangePercentage);
      function syncTimesliceWithTimeRangePercentage(startPercentage, endPercentage) {
        if (startPercentage === undefined || endPercentage === undefined) {
          if (timeslice$.value !== undefined) {
            timeslice$.next(undefined);
          }
          return;
        }
        const {
          stepSize,
          timeRange,
          timeRangeBounds
        } = timeRangeMeta$.value;
        const from = timeRangeBounds[_time_utils.FROM_INDEX] + startPercentage * timeRange;
        const to = timeRangeBounds[_time_utils.FROM_INDEX] + endPercentage * timeRange;
        timeslice$.next([(0, _time_utils.roundDownToNextStepSizeFactor)(from, stepSize), (0, _time_utils.roundUpToNextStepSizeFactor)(to, stepSize)]);
        setSelectedRange(to - from);
      }
      function setTimeslice(timeslice) {
        timeRangePercentage.setTimeRangePercentage(timeslice, timeRangeMeta$.value);
        timeslice$.next(timeslice);
      }
      function setIsAnchored(isAnchored) {
        isAnchored$.next(isAnchored);
      }
      let selectedRange;
      function setSelectedRange(nextSelectedRange) {
        selectedRange = nextSelectedRange !== undefined && nextSelectedRange < timeRangeMeta$.value.timeRange ? nextSelectedRange : undefined;
      }
      function onChange(timeslice) {
        hasTimeSliceSelection$.next(Boolean(timeslice));
        setTimeslice(timeslice);
        const nextSelectedRange = timeslice ? timeslice[_time_utils.TO_INDEX] - timeslice[_time_utils.FROM_INDEX] : undefined;
        setSelectedRange(nextSelectedRange);
      }
      function onPrevious() {
        const {
          ticks,
          timeRangeMax,
          timeRangeMin
        } = timeRangeMeta$.value;
        const value = timeslice$.value;
        const tickRange = ticks[1].value - ticks[0].value;
        if (isAnchored$.value) {
          const prevTick = value ? [...ticks].reverse().find(tick => {
            return tick.value < value[_time_utils.TO_INDEX];
          }) : ticks[ticks.length - 1];
          setTimeslice([timeRangeMin, prevTick ? prevTick.value : timeRangeMax]);
          return;
        }
        if (value === undefined || value[_time_utils.FROM_INDEX] <= timeRangeMin) {
          const to = timeRangeMax;
          if (selectedRange === undefined || selectedRange === tickRange) {
            const lastTickValue = ticks[ticks.length - 1].value;
            const secondToLastTickValue = ticks[ticks.length - 2].value;
            const from = lastTickValue === to ? secondToLastTickValue : lastTickValue;
            setTimeslice([from, to]);
            setSelectedRange(tickRange);
          } else {
            const from = to - selectedRange;
            setTimeslice([Math.max(from, timeRangeMin), to]);
          }
          return;
        }
        const to = value[_time_utils.FROM_INDEX];
        const safeRange = selectedRange === undefined ? tickRange : selectedRange;
        const from = to - safeRange;
        setTimeslice([Math.max(from, timeRangeMin), to]);
      }
      function onNext() {
        const {
          ticks,
          timeRangeMax,
          timeRangeMin
        } = timeRangeMeta$.value;
        const value = timeslice$.value;
        const tickRange = ticks[1].value - ticks[0].value;
        if (isAnchored$.value) {
          if (value === undefined || value[_time_utils.TO_INDEX] >= timeRangeMax) {
            setTimeslice([timeRangeMin, ticks[0].value]);
            return;
          }
          const nextTick = ticks.find(tick => {
            return tick.value > value[_time_utils.TO_INDEX];
          });
          setTimeslice([timeRangeMin, nextTick ? nextTick.value : timeRangeMax]);
          return;
        }
        if (value === undefined || value[_time_utils.TO_INDEX] >= timeRangeMax) {
          const from = timeRangeMin;
          if (selectedRange === undefined || selectedRange === tickRange) {
            const firstTickValue = ticks[0].value;
            const secondTickValue = ticks[1].value;
            const to = firstTickValue === from ? secondTickValue : firstTickValue;
            setTimeslice([from, to]);
            setSelectedRange(tickRange);
          } else {
            const to = from + selectedRange;
            setTimeslice([from, Math.min(to, timeRangeMax)]);
          }
          return;
        }
        const from = value[_time_utils.TO_INDEX];
        const safeRange = selectedRange === undefined ? tickRange : selectedRange;
        const to = from + safeRange;
        setTimeslice([from, Math.min(to, timeRangeMax)]);
      }
      const viewModeSubject = (_getViewModeSubject = (0, _presentationPublishing.getViewModeSubject)(controlGroupApi)) !== null && _getViewModeSubject !== void 0 ? _getViewModeSubject : new _rxjs.BehaviorSubject('view');
      const defaultControlManager = (0, _default_control_manager.initializeDefaultControlManager)({
        ...initialState,
        width: 'large'
      });
      const dashboardDataLoading$ = (0, _presentationPublishing.apiHasParentApi)(controlGroupApi) && (0, _presentationPublishing.apiPublishesDataLoading)(controlGroupApi.parentApi) ? controlGroupApi.parentApi.dataLoading$ : new _rxjs.BehaviorSubject(false);
      const waitForDashboardPanelsToLoad$ = dashboardDataLoading$.pipe(
      // debounce to give time for panels to start loading if they are going to load from time changes
      (0, _rxjs.debounceTime)(300), (0, _rxjs.first)(isLoading => {
        return !isLoading;
      }), (0, _rxjs.map)(() => {
        // Observable notifies subscriber when loading is finished
        // Return void to not expose internal implementation details of observable
        return;
      }));
      function serializeState() {
        return {
          rawState: {
            ...defaultControlManager.getLatestState(),
            ...timeRangePercentage.getLatestState(),
            isAnchored: isAnchored$.value
          },
          references: []
        };
      }
      const unsavedChangesApi = (0, _presentationContainers.initializeUnsavedChanges)({
        uuid,
        parentApi: controlGroupApi,
        serializeState,
        anyStateChange$: (0, _rxjs.merge)(defaultControlManager.anyStateChange$, timeRangePercentage.anyStateChange$, isAnchored$.pipe((0, _rxjs.map)(() => undefined))),
        getComparators: () => {
          return {
            ..._default_control_manager.defaultControlComparators,
            ..._init_time_range_percentage.timeRangePercentageComparators,
            width: 'skip',
            isAnchored: 'skip'
          };
        },
        onReset: lastSaved => {
          var _lastSaved$rawState;
          defaultControlManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
          timeRangePercentage.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
          setIsAnchored(lastSaved === null || lastSaved === void 0 ? void 0 : (_lastSaved$rawState = lastSaved.rawState) === null || _lastSaved$rawState === void 0 ? void 0 : _lastSaved$rawState.isAnchored);
        }
      });
      const api = finalizeApi({
        ...unsavedChangesApi,
        ...defaultControlManager.api,
        defaultTitle$: new _rxjs.BehaviorSubject(displayName),
        timeslice$,
        serializeState,
        clearSelections: () => {
          setTimeslice(undefined);
          hasTimeSliceSelection$.next(false);
        },
        hasSelections$: hasTimeSliceSelection$,
        CustomPrependComponent: () => {
          const [autoApplySelections, viewMode] = (0, _presentationPublishing.useBatchedPublishingSubjects)(controlGroupApi.autoApplySelections$, viewModeSubject);
          return /*#__PURE__*/_react.default.createElement(_time_slider_prepend.TimeSliderPrepend, {
            onNext: onNext,
            onPrevious: onPrevious,
            viewMode: viewMode,
            disablePlayButton: !autoApplySelections,
            setIsPopoverOpen: value => isPopoverOpen$.next(value),
            waitForControlOutputConsumersToLoad$: waitForDashboardPanelsToLoad$,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 272,
              columnNumber: 13
            }
          });
        }
      });
      const timeRangeMetaSubscription = timeRangeMeta$.subscribe(timeRangeMeta => {
        const {
          timesliceStartAsPercentageOfTimeRange,
          timesliceEndAsPercentageOfTimeRange
        } = timeRangePercentage.getLatestState();
        syncTimesliceWithTimeRangePercentage(timesliceStartAsPercentageOfTimeRange, timesliceEndAsPercentageOfTimeRange);
      });
      return {
        api,
        Component: controlPanelClassNames => {
          const [isAnchored, isPopoverOpen, timeRangeMeta, timeslice] = (0, _presentationPublishing.useBatchedPublishingSubjects)(isAnchored$, isPopoverOpen$, timeRangeMeta$, timeslice$);
          (0, _react.useEffect)(() => {
            return () => {
              cleanupTimeRangeSubscription();
              timeRangeMetaSubscription.unsubscribe();
            };
          }, []);
          const from = (0, _react.useMemo)(() => {
            return timeslice ? timeslice[_time_utils.FROM_INDEX] : timeRangeMeta.timeRangeMin;
          }, [timeslice, timeRangeMeta.timeRangeMin]);
          const to = (0, _react.useMemo)(() => {
            return timeslice ? timeslice[_time_utils.TO_INDEX] : timeRangeMeta.timeRangeMax;
          }, [timeslice, timeRangeMeta.timeRangeMax]);
          const value = (0, _react.useMemo)(() => {
            return [from, to];
          }, [from, to]);
          return /*#__PURE__*/_react.default.createElement(_eui.EuiInputPopover, (0, _extends2.default)({}, controlPanelClassNames, {
            panelClassName: "timeSlider__panelOverride",
            input: /*#__PURE__*/_react.default.createElement(_time_slider_popover_button.TimeSliderPopoverButton, {
              onClick: () => {
                isPopoverOpen$.next(!isPopoverOpen);
              },
              formatDate: formatDate,
              from: from,
              to: to,
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 320,
                columnNumber: 17
              }
            }),
            isOpen: isPopoverOpen,
            closePopover: () => isPopoverOpen$.next(false),
            panelPaddingSize: "s",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 316,
              columnNumber: 13
            }
          }), /*#__PURE__*/_react.default.createElement(_time_slider_popover_content.TimeSliderPopoverContent, {
            isAnchored: typeof isAnchored === 'boolean' ? isAnchored : false,
            setIsAnchored: setIsAnchored,
            value: value,
            onChange: onChange,
            stepSize: timeRangeMeta.stepSize,
            ticks: timeRangeMeta.ticks,
            timeRangeMin: timeRangeMeta.timeRangeMin,
            timeRangeMax: timeRangeMeta.timeRangeMax,
            compressed: (0, _is_compressed.isCompressed)(api),
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 333,
              columnNumber: 15
            }
          }));
        }
      };
    }
  };
};
exports.getTimesliderControlFactory = getTimesliderControlFactory;