"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRulesWithUpdatedState = createRulesWithUpdatedState;
exports.useChangeCspRuleState = exports.showChangeBenchmarkRulesStatesErrorToast = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactQuery = require("@tanstack/react-query");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _use_csp_rules_state = require("./use_csp_rules_state");
var _api = require("../../common/api");
var _use_csp_benchmark_integrations = require("../benchmarks/use_csp_benchmark_integrations");
var _constants = require("../../../common/constants");
var _use_kibana = require("../../common/hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/pages/rules/use_change_csp_rule_state.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const showChangeBenchmarkRulesStatesErrorToast = (cloudSecurityStartServices, error) => {
  return cloudSecurityStartServices.notifications.toasts.addDanger({
    title: _i18n.i18n.translate('xpack.csp.rules.changeRuleStateErrorTitle', {
      defaultMessage: 'Unable to update rule'
    }),
    text: _i18n.i18n.translate('xpack.csp.rules.changeRuleStateErrorText', {
      defaultMessage: 'An error occurred while updating the rule: {errorMessage}.',
      values: {
        errorMessage: error.message
      }
    }),
    'data-test-subj': 'csp:toast-error'
  });
};
exports.showChangeBenchmarkRulesStatesErrorToast = showChangeBenchmarkRulesStatesErrorToast;
const showChangeBenchmarkRuleStatesSuccessToast = (cloudSecurityStartServices, data) => {
  const {
    notifications,
    analytics,
    i18n,
    theme
  } = cloudSecurityStartServices;
  const startServices = {
    analytics,
    i18n,
    theme
  };
  return notifications.toasts.addSuccess({
    toastLifeTimeMs: 10000,
    color: 'success',
    iconType: '',
    'data-test-subj': 'csp:toast-success-rule-state-change',
    title: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      "data-test-subj": `csp:toast-success-rule-title`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 9
      }
    }, data.newState === 'unmute' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.flyout.ruleEnabledToastTitle",
      defaultMessage: "Rule Enabled",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 13
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.flyout.ruleDisabledToastTitle",
      defaultMessage: "Rule Disabled",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 13
      }
    }))), startServices),
    text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 7
      }
    }, data.newState === 'unmute' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.flyout.ruleEnabledToastRulesCount",
      defaultMessage: "Successfully enabled {ruleCount, plural, one {# rule} other {# rules}} ",
      values: {
        ruleCount: data.numberOfRules
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 11
      }
    }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.flyout.ruleDisabledToastRulesCount",
      defaultMessage: "Successfully disabled {ruleCount, plural, one {# rule} other {# rules}} ",
      values: {
        ruleCount: data.numberOfRules
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 13
      }
    }), data.newState === 'mute' && data.numberOfDetectionRules > 0 && /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.flyout.ruleDisabledToastDetectionRulesCount",
      defaultMessage: " and {detectionRuleCount, plural, one {# detection rule} other {# detection rules}}",
      values: {
        detectionRuleCount: data.numberOfDetectionRules
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 17
      }
    })))), startServices)
  });
};
const useChangeCspRuleState = () => {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  const {
    notifications,
    analytics,
    i18n: i18nStart,
    theme
  } = (0, _use_kibana.useKibana)().services;
  const startServices = {
    notifications,
    analytics,
    i18n: i18nStart,
    theme
  };
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _reactQuery.useMutation)({
    mutationFn: async ruleStateUpdateRequest => {
      return await (http === null || http === void 0 ? void 0 : http.post(_constants.CSP_BENCHMARK_RULES_BULK_ACTION_ROUTE_PATH, {
        version: '1',
        body: JSON.stringify({
          action: ruleStateUpdateRequest.newState,
          rules: ruleStateUpdateRequest.ruleIds
        })
      }));
    },
    onMutate: async ruleStateUpdateRequest => {
      // Cancel any outgoing refetches (so they don't overwrite our optimistic update)
      await queryClient.cancelQueries(_use_csp_rules_state.CSP_RULES_STATES_QUERY_KEY);

      // Snapshot the previous rules
      const previousCspRules = queryClient.getQueryData(_use_csp_rules_state.CSP_RULES_STATES_QUERY_KEY);

      // Optimistically update to the rules that have state changes
      queryClient.setQueryData(_use_csp_rules_state.CSP_RULES_STATES_QUERY_KEY, currentRuleStates => {
        if (!currentRuleStates) {
          return currentRuleStates;
        }
        return createRulesWithUpdatedState(ruleStateUpdateRequest, currentRuleStates);
      });

      // Return a context object with the previous value
      return {
        previousCspRules
      };
    },
    onSuccess: (data, variables) => {
      var _Object$keys, _data$disabled_detect;
      queryClient.invalidateQueries(_use_csp_benchmark_integrations.BENCHMARK_INTEGRATION_QUERY_KEY_V2);
      queryClient.invalidateQueries([_api.CSPM_STATS_QUERY_KEY]);
      queryClient.invalidateQueries([_api.KSPM_STATS_QUERY_KEY]);
      queryClient.invalidateQueries(_use_csp_rules_state.CSP_RULES_STATES_QUERY_KEY);
      showChangeBenchmarkRuleStatesSuccessToast(startServices, {
        newState: variables === null || variables === void 0 ? void 0 : variables.newState,
        numberOfRules: ((_Object$keys = Object.keys((data === null || data === void 0 ? void 0 : data.updated_benchmark_rules) || {})) === null || _Object$keys === void 0 ? void 0 : _Object$keys.length) || 0,
        numberOfDetectionRules: (data === null || data === void 0 ? void 0 : (_data$disabled_detect = data.disabled_detection_rules) === null || _data$disabled_detect === void 0 ? void 0 : _data$disabled_detect.length) || 0
      });
    },
    onError: (error, _, context) => {
      if (context !== null && context !== void 0 && context.previousCspRules) {
        queryClient.setQueryData(_use_csp_rules_state.CSP_RULES_STATES_QUERY_KEY, context.previousCspRules);
      }
      showChangeBenchmarkRulesStatesErrorToast(startServices, error);
    }
  });
};
exports.useChangeCspRuleState = useChangeCspRuleState;
function createRulesWithUpdatedState(ruleStateUpdateRequest, currentRuleStates) {
  const updateRuleStates = {};
  ruleStateUpdateRequest.ruleIds.forEach(ruleId => {
    const matchingRuleKey = Object.keys(currentRuleStates).find(key => currentRuleStates[key].rule_id === ruleId.rule_id);
    if (matchingRuleKey) {
      const updatedRule = {
        ...currentRuleStates[matchingRuleKey],
        muted: ruleStateUpdateRequest.newState === 'mute'
      };
      updateRuleStates[matchingRuleKey] = updatedRule;
    }
  });
  return {
    ...currentRuleStates,
    ...updateRuleStates
  };
}