"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isUserCommentSO = exports.isPersistableStateAttachmentSO = exports.isDeferredMigration = exports.getLensMigrations = void 0;
exports.logError = logError;
exports.pipeMigrations = pipeMigrations;
var _valid = _interopRequireDefault(require("semver/functions/valid"));
var _gte = _interopRequireDefault(require("semver/functions/gte"));
var _lodash = require("lodash");
var _domain = require("../../../common/types/domain");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function logError({
  id,
  context,
  error,
  docType,
  docKey
}) {
  context.log.error(`Failed to migrate ${docType} with doc id: ${id} version: ${context.migrationVersion} error: ${error.message}`, {
    migrations: {
      [docKey]: {
        id
      }
    }
  });
}
function pipeMigrations(...migrations) {
  return doc => migrations.reduce((migratedDoc, nextMigration) => nextMigration(migratedDoc), doc);
}
const isDeferredMigration = (minDeferredKibanaVersion, migrationVersion) => Boolean((0, _valid.default)(migrationVersion) && (0, _valid.default)(minDeferredKibanaVersion) && (0, _gte.default)(migrationVersion, minDeferredKibanaVersion));
exports.isDeferredMigration = isDeferredMigration;
const isUserCommentSO = doc => {
  return doc.attributes.type === _domain.AttachmentType.user;
};
exports.isUserCommentSO = isUserCommentSO;
const isPersistableStateAttachmentSO = doc => {
  return doc.attributes.type === _domain.AttachmentType.persistableState;
};
exports.isPersistableStateAttachmentSO = isPersistableStateAttachmentSO;
const getLensMigrations = ({
  lensEmbeddableFactory,
  migratorFactory
}) => {
  const lensMigrations = lensEmbeddableFactory().migrations;
  const lensMigrationObject = (0, _lodash.isFunction)(lensMigrations) ? lensMigrations() : lensMigrations || {};
  const embeddableMigrations = (0, _lodash.mapValues)(lensMigrationObject, migratorFactory);
  return embeddableMigrations;
};
exports.getLensMigrations = getLensMigrations;