"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isCasesConnectorError = exports.isCasesClientError = exports.CasesConnectorError = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _error = require("../../common/error");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CasesConnectorError extends Error {
  constructor(message, statusCode) {
    super(message);
    (0, _defineProperty2.default)(this, "statusCode", void 0);
    this.statusCode = statusCode;
  }
}
exports.CasesConnectorError = CasesConnectorError;
const isCasesConnectorError = error => error instanceof CasesConnectorError;
exports.isCasesConnectorError = isCasesConnectorError;
const isCasesClientError = error => error instanceof _error.CaseError;
exports.isCasesClientError = isCasesClientError;