"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.canUpload = canUpload;
exports.getTextarea = getTextarea;
exports.markdownImage = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns a markdown link for the file with a link to the asset
 */
const markdownImage = (fileName, fileUrl, ext) => `![${fileName}${ext ? `.${ext}` : ''}](${fileUrl})`;

/**
 * Gets the reference to the textarea element from the markdown editor
 */
exports.markdownImage = markdownImage;
function getTextarea(editorRef) {
  if (!editorRef || typeof editorRef === 'function' || !editorRef.current) {
    return null;
  }
  return editorRef.current.textarea;
}
function canUpload(uploadState, caseId) {
  return uploadState.hasFiles() && !uploadState.isUploading() && caseId;
}