"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ArgSimpleForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _tooltip_icon = require("../tooltip_icon");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/arg_form/arg_simple_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const strings = {
  getRemoveAriaLabel: () => _i18n.i18n.translate('xpack.canvas.argFormArgSimpleForm.removeAriaLabel', {
    defaultMessage: 'Remove'
  }),
  getRequiredTooltip: () => _i18n.i18n.translate('xpack.canvas.argFormArgSimpleForm.requiredTooltip', {
    defaultMessage: 'This argument is required, you should specify a value.'
  })
};
// This is what is being generated by render() from the Arg class. It is called in FunctionForm
const ArgSimpleForm = ({
  children,
  required,
  valueMissing,
  onRemove
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    className: "canvasArg__form",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }, children), valueMissing && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_tooltip_icon.TooltipIcon, {
    position: "left",
    icon: _tooltip_icon.IconType.error,
    content: strings.getRequiredTooltip(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 11
    }
  })), !required && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: strings.getRemoveAriaLabel(),
    disableScreenReaderOutput: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "text",
    onClick: onRemove,
    iconType: "cross",
    iconSize: "s",
    "aria-label": strings.getRemoveAriaLabel(),
    className: "canvasArg__remove",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 11
    }
  })));
};
exports.ArgSimpleForm = ArgSimpleForm;
ArgSimpleForm.propTypes = {
  children: _propTypes.default.node,
  required: _propTypes.default.bool,
  valueMissing: _propTypes.default.bool,
  onRemove: _propTypes.default.func.isRequired
};