"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvalidLicenseNotification = InvalidLicenseNotification;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_kibana_url = require("../../hooks/use_kibana_url");
var _use_apm_plugin_context = require("../apm_plugin/use_apm_plugin_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/context/license/invalid_license_notification.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function InvalidLicenseNotification() {
  var _licenseManagement$lo;
  const {
    plugins: {
      licenseManagement
    }
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const licensePageUrl = (0, _use_kibana_url.useKibanaUrl)('/app/management/stack/license_management');
  const manageLicenseURL = licenseManagement !== null && licenseManagement !== void 0 && licenseManagement.locator ? licenseManagement === null || licenseManagement === void 0 ? void 0 : (_licenseManagement$lo = licenseManagement.locator) === null || _licenseManagement$lo === void 0 ? void 0 : _licenseManagement$lo.useUrl({
    page: 'dashboard'
  }) : licensePageUrl;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "warning",
    iconColor: "warning",
    title: /*#__PURE__*/_react.default.createElement("h1", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.apm.invalidLicense.title', {
      defaultMessage: 'Invalid License'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.apm.invalidLicense.message', {
      defaultMessage: 'The APM UI is not available because your current license has expired or is no longer valid.'
    })),
    actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "apmInvalidLicenseNotificationManageYourLicenseButton",
      href: manageLicenseURL,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.apm.invalidLicense.licenseManagementLink', {
      defaultMessage: 'Manage your license'
    }))],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  });
}