"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormRowSetting = FormRowSetting;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _codeEditor = require("@kbn/code-editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/fleet_integration/apm_policy_form/settings_form/form_row_setting.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FixedHeightDiv = _styled.default.div`
  height: 300px;
`;
const ENABLED_LABEL = _i18n.i18n.translate('xpack.apm.fleet_integration.settings.enabledLabel', {
  defaultMessage: 'Enabled'
});
const DISABLED_LABEL = _i18n.i18n.translate('xpack.apm.fleet_integration.settings.disabledLabel', {
  defaultMessage: 'Disabled'
});
function FormRowSetting({
  row,
  value,
  onChange,
  isDisabled
}) {
  switch (row.type) {
    case 'boolean':
      {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
          "data-test-subj": row.dataTestSubj,
          disabled: isDisabled,
          label: row.placeholder || (value ? ENABLED_LABEL : DISABLED_LABEL),
          checked: value,
          onChange: e => {
            onChange(row.key, e.target.checked);
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 46,
            columnNumber: 9
          }
        });
      }
    case 'duration':
    case 'storageSize':
    case 'text':
      {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
          "data-test-subj": row.dataTestSubj,
          disabled: isDisabled,
          value: value,
          prepend: isDisabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            type: "lock",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 65,
              columnNumber: 33
            }
          }) : undefined,
          onChange: e => {
            onChange(row.key, e.target.value);
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 61,
            columnNumber: 9
          }
        });
      }
    case 'area':
      {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
          "data-test-subj": row.dataTestSubj,
          disabled: isDisabled,
          value: value,
          onChange: e => {
            onChange(row.key, e.target.value);
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 74,
            columnNumber: 9
          }
        });
      }
    case 'bytes':
    case 'integer':
      {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
          "data-test-subj": row.dataTestSubj,
          disabled: isDisabled,
          value: value,
          onChange: e => {
            onChange(row.key, e.target.value);
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 87,
            columnNumber: 9
          }
        });
      }
    case 'combo':
      {
        const comboOptions = Array.isArray(value) ? value.map(label => ({
          label
        })) : [];
        return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
          "aria-label": _i18n.i18n.translate('xpack.apm.formRowSetting.selectorcreateoptionsComboBox.ariaLabel', {
            defaultMessage: 'Select or create options'
          }),
          "data-test-subj": row.dataTestSubj,
          noSuggestions: true,
          placeholder: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.selectOrCreateOptions', {
            defaultMessage: 'Select or create options'
          }),
          options: comboOptions,
          selectedOptions: comboOptions,
          onChange: option => {
            onChange(row.key, option.map(({
              label
            }) => label));
          },
          onCreateOption: newOption => {
            onChange(row.key, [...value, newOption]);
          },
          isClearable: true,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 100,
            columnNumber: 9
          }
        });
      }
    case 'yaml':
      {
        return /*#__PURE__*/_react.default.createElement(FixedHeightDiv, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 128,
            columnNumber: 9
          }
        }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
          languageId: "yaml",
          width: "100%",
          height: "300px",
          value: value,
          onChange: val => {
            onChange(row.key, val);
          },
          options: {
            ariaLabel: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.yamlCodeEditor', {
              defaultMessage: 'YAML Code Editor'
            }),
            wordWrap: 'off',
            tabSize: 2,
            // To avoid left margin
            lineNumbers: 'off',
            lineNumbersMinChars: 0,
            folding: false,
            lineDecorationsWidth: 0,
            overviewRulerBorder: false
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 129,
            columnNumber: 11
          }
        }));
      }
    case 'secret':
      {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldPassword, {
          type: "dual",
          value: value !== null && value !== void 0 ? value : '',
          onChange: e => {
            onChange(row.key, e.target.value);
          },
          disabled: isDisabled,
          "data-test-subj": row.dataTestSubj,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 156,
            columnNumber: 9
          }
        });
      }
    default:
      throw new Error(`Unknown type "${row.type}"`);
  }
}