"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionOverview = TransactionOverview;
var _eui = require("@elastic/eui");
var _ebtTools = require("@kbn/ebt-tools");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _agent_name = require("../../../../common/agent_name");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _use_apm_service_context = require("../../../context/apm_service/use_apm_service_context");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_local_storage = require("../../../hooks/use_local_storage");
var _use_time_range = require("../../../hooks/use_time_range");
var _aggregated_transactions_badge = require("../../shared/aggregated_transactions_badge");
var _transaction_charts = require("../../shared/charts/transaction_charts");
var _url_helpers = require("../../shared/links/url_helpers");
var _slo_callout = require("../../shared/slo_callout");
var _transactions_table = require("../../shared/transactions_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/transaction_overview/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function TransactionOverview() {
  var _useApmPluginContext$;
  const {
    query: {
      environment,
      kuery,
      rangeFrom,
      rangeTo,
      transactionType: transactionTypeFromUrl,
      comparisonEnabled,
      offset
    }
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/transactions');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    transactionType,
    fallbackToTransactions,
    serverlessType,
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    onPageReady
  } = (0, _ebtTools.usePerformanceContext)();
  const history = (0, _reactRouterDom.useHistory)();

  // redirect to first transaction type
  if (!transactionTypeFromUrl && transactionType) {
    (0, _url_helpers.replace)(history, {
      query: {
        transactionType
      }
    });
  }
  const isServerless = (0, _agent_name.isServerlessAgentName)(serverlessType);
  const [sloCalloutDismissed, setSloCalloutDismissed] = (0, _use_local_storage.useLocalStorage)('apm.sloCalloutDismissed', false);
  const setScreenContext = (_useApmPluginContext$ = (0, _use_apm_plugin_context.useApmPluginContext)().observabilityAIAssistant) === null || _useApmPluginContext$ === void 0 ? void 0 : _useApmPluginContext$.service.setScreenContext;
  (0, _react.useEffect)(() => {
    return setScreenContext === null || setScreenContext === void 0 ? void 0 : setScreenContext({
      screenDescription: `The user is looking at the transactions overview for ${serviceName}, and the transaction type is ${transactionType}`
    });
  }, [setScreenContext, serviceName, transactionType]);
  const handleOnLoadTable = (0, _react.useCallback)(() => {
    onPageReady({
      meta: {
        rangeFrom: start,
        rangeTo: end
      }
    });
  }, [start, end, onPageReady]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !sloCalloutDismissed && /*#__PURE__*/_react.default.createElement(_slo_callout.SloCallout, {
    dismissCallout: () => {
      setSloCalloutDismissed(true);
    },
    serviceName: serviceName,
    environment: environment,
    transactionType: transactionType,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }), fallbackToTransactions && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_aggregated_transactions_badge.AggregatedTransactionsBadge, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_transaction_charts.TransactionCharts, {
    serviceName: serviceName,
    kuery: kuery,
    environment: environment,
    start: start,
    end: end,
    isServerlessContext: isServerless,
    comparisonEnabled: comparisonEnabled,
    offset: offset,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_transactions_table.TransactionsTable, {
    hideViewTransactionsLink: true,
    numberOfTransactionsPerPage: 10,
    showMaxTransactionGroupsExceededWarning: true,
    environment: environment,
    kuery: kuery,
    start: start,
    end: end,
    saveTableOptionsToUrl: true,
    onLoadTable: handleOnLoadTable,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  })));
}