"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MobileErrorGroupList = MobileErrorGroupList;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _react = _interopRequireWildcard(require("react"));
var _apmUiShared = require("@kbn/apm-ui-shared");
var _i18n2 = require("../../../../../../common/i18n");
var _formatters = require("../../../../../../common/utils/formatters");
var _use_apm_params = require("../../../../../hooks/use_apm_params");
var _style = require("../../../../../utils/style");
var _get_timeseries_color = require("../../../../shared/charts/helper/get_timeseries_color");
var _spark_plot = require("../../../../shared/charts/spark_plot");
var _error_detail_link = require("../../../../shared/links/apm/mobile/error_detail_link");
var _error_overview_link = require("../../../../shared/links/apm/mobile/error_overview_link");
var _managed_table = require("../../../../shared/managed_table");
var _get_comparison_options = require("../../../../shared/time_comparison/get_comparison_options");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/mobile/errors_and_crashes_overview/error_group_list/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GroupIdLink = (0, _styled.default)(_error_detail_link.ErrorDetailLink)`
  font-family: ${({
  theme
}) => theme.euiTheme.font.familyCode};
`;
const MessageAndCulpritCell = _styled.default.div`
  ${(0, _style.truncate)('100%')};
`;
const ErrorLink = (0, _styled.default)(_error_overview_link.ErrorOverviewLink)`
  ${(0, _style.truncate)('100%')};
`;
const MessageLink = (0, _styled.default)(_error_detail_link.ErrorDetailLink)`
  font-family: ${({
  theme
}) => theme.euiTheme.font.familyCode};
  ${(0, _style.truncate)('100%')};
`;
function MobileErrorGroupList({
  mainStatistics,
  serviceName,
  detailedStatisticsLoading,
  detailedStatistics,
  comparisonEnabled,
  initialSortField,
  initialSortDirection,
  isLoading
}) {
  const {
    query
  } = (0, _use_apm_params.useApmParams)('/mobile-services/{serviceName}/errors-and-crashes');
  const {
    offset
  } = query;
  const columns = (0, _react.useMemo)(() => {
    return [{
      name: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.apm.errorsTable.groupIdColumnLabel', {
        defaultMessage: 'Group ID'
      }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        size: "s",
        type: "question",
        color: "subdued",
        iconProps: {
          className: 'eui-alignTop'
        },
        content: _i18n.i18n.translate('xpack.apm.errorsTable.groupIdColumnDescription', {
          defaultMessage: 'Hash of the stack trace. Groups similar errors together, even when the error message is different due to dynamic parameters.'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 13
        }
      })),
      field: 'groupId',
      sortable: false,
      width: `${_style.unit * 6}px`,
      render: (_, item) => {
        return /*#__PURE__*/_react.default.createElement(GroupIdLink, {
          serviceName: serviceName,
          groupId: item.groupId,
          query: query,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 101,
            columnNumber: 13
          }
        }, item.groupId.slice(0, 5) || _i18n2.NOT_AVAILABLE_LABEL);
      }
    }, {
      name: _i18n.i18n.translate('xpack.apm.errorsTable.typeColumnLabel', {
        defaultMessage: 'Type'
      }),
      field: 'type',
      sortable: false,
      render: (_, {
        type
      }) => {
        return /*#__PURE__*/_react.default.createElement(ErrorLink, {
          title: type,
          serviceName: serviceName,
          query: {
            ...query,
            kuery: `error.exception.type:"${type}"`
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 115,
            columnNumber: 13
          }
        }, type);
      }
    }, {
      name: _i18n.i18n.translate('xpack.apm.errorsTable.errorMessageColumnLabel', {
        defaultMessage: 'Error message'
      }),
      field: 'message',
      sortable: false,
      width: '30%',
      render: (_, item) => {
        return /*#__PURE__*/_react.default.createElement(MessageAndCulpritCell, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 137,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          id: "error-message-tooltip",
          content: item.name || _i18n2.NOT_AVAILABLE_LABEL,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 138,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(MessageLink, {
          serviceName: serviceName,
          groupId: item.groupId,
          query: query,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 139,
            columnNumber: 17
          }
        }, item.name || _i18n2.NOT_AVAILABLE_LABEL)));
      }
    }, {
      name: '',
      field: 'handled',
      sortable: false,
      align: _eui.RIGHT_ALIGNMENT,
      render: (_, {
        handled
      }) => handled === false && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "warning",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 154,
          columnNumber: 13
        }
      }, _i18n.i18n.translate('xpack.apm.errorsTable.unhandledLabel', {
        defaultMessage: 'Unhandled'
      }))
    }, {
      field: 'lastSeen',
      sortable: true,
      name: _i18n.i18n.translate('xpack.apm.errorsTable.lastSeenColumnLabel', {
        defaultMessage: 'Last seen'
      }),
      align: _eui.LEFT_ALIGNMENT,
      render: (_, {
        lastSeen
      }) => lastSeen ? /*#__PURE__*/_react.default.createElement(_apmUiShared.Timestamp, {
        timestamp: lastSeen,
        timeUnit: "minutes",
        renderMode: "tooltip",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 170,
          columnNumber: 13
        }
      }) : _i18n2.NOT_AVAILABLE_LABEL
    }, {
      field: 'occurrences',
      name: _i18n.i18n.translate('xpack.apm.errorsTable.occurrencesColumnLabel', {
        defaultMessage: 'Occurrences'
      }),
      sortable: true,
      dataType: 'number',
      align: _eui.RIGHT_ALIGNMENT,
      render: (_, {
        occurrences,
        groupId
      }) => {
        var _detailedStatistics$c, _detailedStatistics$c2, _detailedStatistics$p, _detailedStatistics$p2;
        const currentPeriodTimeseries = detailedStatistics === null || detailedStatistics === void 0 ? void 0 : (_detailedStatistics$c = detailedStatistics.currentPeriod) === null || _detailedStatistics$c === void 0 ? void 0 : (_detailedStatistics$c2 = _detailedStatistics$c[groupId]) === null || _detailedStatistics$c2 === void 0 ? void 0 : _detailedStatistics$c2.timeseries;
        const previousPeriodTimeseries = detailedStatistics === null || detailedStatistics === void 0 ? void 0 : (_detailedStatistics$p = detailedStatistics.previousPeriod) === null || _detailedStatistics$p === void 0 ? void 0 : (_detailedStatistics$p2 = _detailedStatistics$p[groupId]) === null || _detailedStatistics$p2 === void 0 ? void 0 : _detailedStatistics$p2.timeseries;
        const {
          currentPeriodColor,
          previousPeriodColor
        } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.FAILED_TRANSACTION_RATE);
        return /*#__PURE__*/_react.default.createElement(_spark_plot.SparkPlot, {
          type: "bar",
          color: currentPeriodColor,
          isLoading: detailedStatisticsLoading,
          series: currentPeriodTimeseries,
          valueLabel: _i18n.i18n.translate('xpack.apm.serviceOverview.errorsTableOccurrences', {
            defaultMessage: `{occurrences} occ.`,
            values: {
              occurrences: (0, _formatters.asInteger)(occurrences)
            }
          }),
          comparisonSeries: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? previousPeriodTimeseries : undefined,
          comparisonSeriesColor: previousPeriodColor,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 192,
            columnNumber: 13
          }
        });
      }
    }];
  }, [serviceName, query, detailedStatistics, comparisonEnabled, detailedStatisticsLoading, offset]);
  return /*#__PURE__*/_react.default.createElement(_managed_table.ManagedTable, {
    noItemsMessage: isLoading ? _i18n.i18n.translate('xpack.apm.errorsTable.loading', {
      defaultMessage: 'Loading...'
    }) : _i18n.i18n.translate('xpack.apm.errorsTable.noErrorsLabel', {
      defaultMessage: 'No errors found'
    }),
    items: mainStatistics,
    columns: columns,
    initialSortField: initialSortField,
    initialSortDirection: initialSortDirection,
    sortItems: false,
    initialPageSize: 25,
    isLoading: isLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 5
    }
  });
}