/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.support.xcontent;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.ObjectPath;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.XContentUtils;

public class XContentSource
implements ToXContent {
    private final BytesReference bytes;
    private final XContentType contentType;
    private Object data;

    public XContentSource(BytesReference bytes, XContentType xContentType) throws ElasticsearchParseException {
        if (xContentType == null) {
            throw new IllegalArgumentException("xContentType must not be null");
        }
        this.bytes = bytes;
        this.contentType = xContentType;
    }

    public XContentSource(XContentBuilder builder) {
        this(BytesReference.bytes((XContentBuilder)builder), builder.contentType());
    }

    public XContentType getContentType() {
        return this.contentType;
    }

    public BytesReference getBytes() {
        return this.bytes;
    }

    public boolean isMap() {
        return this.data() instanceof Map;
    }

    public Map<String, Object> getAsMap() {
        return (Map)this.data();
    }

    public boolean isList() {
        return this.data() instanceof List;
    }

    public List<Object> getAsList() {
        return (List)this.data();
    }

    public <T> T getValue(String path) {
        return (T)ObjectPath.eval((String)path, (Object)this.data());
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        try (XContentParser parser = this.parser(this.bytes);){
            parser.nextToken();
            builder.generator().copyCurrentStructure(parser);
            XContentBuilder xContentBuilder = builder;
            return xContentBuilder;
        }
    }

    public XContentParser parser(BytesReference bytes) throws IOException {
        return XContentHelper.createParserNotCompressed((XContentParserConfiguration)LoggingDeprecationHandler.XCONTENT_PARSER_CONFIG, (BytesReference)bytes, (XContentType)this.contentType);
    }

    public static XContentSource readFrom(StreamInput in) throws IOException {
        return new XContentSource(in.readBytesReference(), (XContentType)in.readEnum(XContentType.class));
    }

    public static void writeTo(XContentSource source, StreamOutput out) throws IOException {
        out.writeBytesReference(source.bytes);
        XContentHelper.writeTo((StreamOutput)out, (XContentType)source.contentType);
    }

    private Object data() {
        if (this.data == null) {
            try (XContentParser parser = this.parser(this.bytes);){
                this.data = XContentUtils.readValue((XContentParser)parser, (XContentParser.Token)parser.nextToken());
            }
            catch (IOException ex) {
                throw new ElasticsearchException("failed to read value", (Throwable)ex, new Object[0]);
            }
        }
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XContentSource that = (XContentSource)o;
        return Objects.equals(this.data(), that.data());
    }

    public int hashCode() {
        return Objects.hash(this.data());
    }

    public String toString() {
        return this.bytes.utf8ToString();
    }
}

