/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.ml.calendars.Calendar;
import org.elasticsearch.xpack.core.ml.calendars.ScheduledEvent;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class DeleteCalendarEventAction
extends ActionType<AcknowledgedResponse> {
    public static final DeleteCalendarEventAction INSTANCE = new DeleteCalendarEventAction();
    public static final String NAME = "cluster:admin/xpack/ml/calendars/events/delete";

    private DeleteCalendarEventAction() {
        super(NAME);
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private String calendarId;
        private String eventId;

        public Request(StreamInput in) throws IOException {
            super(in);
            this.calendarId = in.readString();
            this.eventId = in.readString();
        }

        public Request(String calendarId, String eventId) {
            super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT, DEFAULT_ACK_TIMEOUT);
            this.calendarId = ExceptionsHelper.requireNonNull(calendarId, Calendar.ID.getPreferredName());
            this.eventId = ExceptionsHelper.requireNonNull(eventId, ScheduledEvent.EVENT_ID.getPreferredName());
        }

        public String getCalendarId() {
            return this.calendarId;
        }

        public String getEventId() {
            return this.eventId;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.calendarId);
            out.writeString(this.eventId);
        }

        public int hashCode() {
            return Objects.hash(this.eventId, this.calendarId);
        }

        public boolean equals(Object obj) {
            if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.eventId, other.eventId) && Objects.equals(this.calendarId, other.calendarId);
        }
    }
}

