/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.ClusterStateActionStep;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleOriginationDateParser;
import org.elasticsearch.xpack.core.ilm.InitializePolicyException;
import org.elasticsearch.xpack.core.ilm.Step;

public final class InitializePolicyContextStep
extends ClusterStateActionStep {
    public static final String INITIALIZATION_PHASE = "new";
    public static final Step.StepKey KEY = new Step.StepKey("new", "init", "init");
    private static final Logger logger = LogManager.getLogger(InitializePolicyContextStep.class);

    InitializePolicyContextStep(Step.StepKey key, Step.StepKey nextStepKey) {
        super(key, nextStepKey);
    }

    @Override
    public ProjectState performAction(Index index, ProjectState projectState) {
        IndexMetadata indexMetadata = projectState.metadata().index(index);
        if (indexMetadata == null) {
            logger.debug("[{}] lifecycle action for index [{}] executed but index no longer exists", (Object)this.getKey().action(), (Object)index.getName());
            return projectState;
        }
        LifecycleExecutionState lifecycleState = indexMetadata.getLifecycleExecutionState();
        if (lifecycleState.lifecycleDate() != null) {
            return projectState;
        }
        LifecycleExecutionState newLifecycleState = LifecycleExecutionState.builder((LifecycleExecutionState)lifecycleState).setIndexCreationDate(Long.valueOf(indexMetadata.getCreationDate())).build();
        Long parsedOriginationDate = null;
        try {
            if (IndexLifecycleOriginationDateParser.shouldParseIndexName(indexMetadata.getSettings())) {
                long parsedDate = IndexLifecycleOriginationDateParser.parseIndexNameAndExtractDate(index.getName());
                parsedOriginationDate = parsedDate;
            }
        }
        catch (Exception e) {
            String policyName = indexMetadata.getLifecyclePolicyName();
            throw new InitializePolicyException(policyName, index.getName(), e);
        }
        if (parsedOriginationDate == null) {
            return projectState.updateProject(projectState.metadata().withLifecycleState(indexMetadata.getIndex(), newLifecycleState));
        }
        IndexMetadata.Builder builder = IndexMetadata.builder((IndexMetadata)indexMetadata);
        builder.settingsVersion(indexMetadata.getSettingsVersion() + 1L).settings(Settings.builder().put(indexMetadata.getSettings()).put("index.lifecycle.origination_date", parsedOriginationDate.longValue()).build());
        builder.putCustom("ilm", newLifecycleState.asMap());
        return projectState.updateProject(ProjectMetadata.builder((ProjectMetadata)projectState.metadata()).put(builder).build());
    }

    @Override
    public boolean isRetryable() {
        return true;
    }
}

