/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.protocol.xpack;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Locale;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class XPackInfoRequest
extends LegacyActionRequest {
    private boolean verbose;
    private EnumSet<Category> categories = EnumSet.noneOf(Category.class);

    public XPackInfoRequest() {
    }

    public XPackInfoRequest(StreamInput in) throws IOException {
        super(in);
        this.verbose = in.readBoolean();
        EnumSet<Category> categories = EnumSet.noneOf(Category.class);
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            categories.add(Category.valueOf(in.readString()));
        }
        this.categories = categories;
        if (XPackInfoRequest.hasLicenseVersionField(in.getTransportVersion())) {
            int n = in.readVInt();
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setCategories(EnumSet<Category> categories) {
        this.categories = categories;
    }

    public EnumSet<Category> getCategories() {
        return this.categories;
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.verbose);
        out.writeVInt(this.categories.size());
        for (Category category : this.categories) {
            out.writeString(category.name());
        }
        if (XPackInfoRequest.hasLicenseVersionField(out.getTransportVersion())) {
            out.writeVInt(5);
        }
    }

    private static boolean hasLicenseVersionField(TransportVersion streamVersion) {
        return streamVersion.between((VersionId)TransportVersions.V_7_8_1, (VersionId)TransportVersions.V_8_0_0);
    }

    public static enum Category {
        BUILD,
        LICENSE,
        FEATURES;


        public static EnumSet<Category> toSet(String ... categories) {
            EnumSet<Category> set = EnumSet.noneOf(Category.class);
            String[] stringArray = categories;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String category;
                switch (category = stringArray[i]) {
                    case "_all": {
                        return EnumSet.allOf(Category.class);
                    }
                    case "_none": {
                        return EnumSet.noneOf(Category.class);
                    }
                }
                set.add(Category.valueOf(category.toUpperCase(Locale.ROOT)));
            }
            return set;
        }
    }
}

