/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.threadpool;

import java.util.List;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.threadpool.ThreadPool;

public abstract class ExecutorBuilder<U extends ExecutorSettings> {
    private final String name;
    private final boolean isSystemThread;

    public ExecutorBuilder(String name, boolean isSystemThread) {
        this.name = name;
        this.isSystemThread = isSystemThread;
    }

    protected String name() {
        return this.name;
    }

    protected static String settingsKey(String prefix, String key) {
        return String.join((CharSequence)".", prefix, key);
    }

    protected static int applyHardSizeLimit(Settings settings, String name) {
        if (name.equals("bulk") || name.equals("write_coordination") || name.equals("system_write_coordination") || name.equals("write") || name.equals("system_write") || name.equals("system_critical_write")) {
            return 1 + EsExecutors.allocatedProcessors(settings);
        }
        return Integer.MAX_VALUE;
    }

    public abstract List<Setting<?>> getRegisteredSettings();

    abstract U getSettings(Settings var1);

    abstract ThreadPool.ExecutorHolder build(U var1, ThreadContext var2);

    abstract String formatInfo(ThreadPool.Info var1);

    public boolean isSystemThread() {
        return this.isSystemThread;
    }

    static abstract class ExecutorSettings {
        protected final String nodeName;

        ExecutorSettings(String nodeName) {
            this.nodeName = nodeName;
        }
    }
}

