/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.cluster.node.info.PluginsAndModules;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.node.ReportingService;
import org.elasticsearch.plugins.ExtensiblePlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.PluginApiInfo;
import org.elasticsearch.plugins.PluginBundle;
import org.elasticsearch.plugins.PluginDescriptor;
import org.elasticsearch.plugins.PluginIntrospector;
import org.elasticsearch.plugins.PluginRuntimeInfo;
import org.elasticsearch.plugins.PluginsLoader;
import org.elasticsearch.plugins.StablePluginPlaceHolder;
import org.elasticsearch.plugins.scanners.StablePluginsRegistry;
import org.elasticsearch.plugins.spi.SPIClassIterator;

public class PluginsService
implements ReportingService<PluginsAndModules> {
    private static final Logger logger = LogManager.getLogger(PluginsService.class);
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(PluginsService.class);
    private final List<LoadedPlugin> plugins;
    private final PluginsAndModules info;
    private final StablePluginsRegistry stablePluginsRegistry = new StablePluginsRegistry();
    public static final Setting<List<String>> MANDATORY_SETTING = Setting.stringListSetting("plugin.mandatory", Setting.Property.NodeScope);
    private static final Set<String> officialPlugins;

    public StablePluginsRegistry getStablePluginRegistry() {
        return this.stablePluginsRegistry;
    }

    public PluginsService(Settings settings, Path configPath, PluginsLoader pluginsLoader) {
        Map<String, LoadedPlugin> loadedPlugins = this.loadPluginBundles(settings, configPath, pluginsLoader);
        List<PluginDescriptor> modulesDescriptors = pluginsLoader.moduleDescriptors();
        List<PluginDescriptor> pluginDescriptors = pluginsLoader.pluginDescriptors();
        PluginIntrospector inspector = PluginIntrospector.getInstance();
        this.info = new PluginsAndModules(PluginsService.getRuntimeInfos(inspector, pluginDescriptors, loadedPlugins), modulesDescriptors);
        this.plugins = List.copyOf(loadedPlugins.values());
        PluginsService.checkDeprecations(inspector, pluginDescriptors, loadedPlugins);
        PluginsService.checkMandatoryPlugins(pluginDescriptors.stream().map(PluginDescriptor::getName).collect(Collectors.toSet()), new HashSet<String>((Collection)MANDATORY_SETTING.get(settings)));
        HashSet<String> moduleNames = new HashSet<String>(modulesDescriptors.stream().map(PluginDescriptor::getName).toList());
        for (String name : loadedPlugins.keySet()) {
            if (moduleNames.contains(name)) {
                logger.info("loaded module [{}]", (Object)name);
                continue;
            }
            logger.info("loaded plugin [{}]", (Object)name);
        }
    }

    static void checkMandatoryPlugins(Set<String> existingPlugins, Set<String> mandatoryPlugins) {
        if (mandatoryPlugins.isEmpty()) {
            return;
        }
        Set<String> missingPlugins = Sets.difference(mandatoryPlugins, existingPlugins);
        if (!missingPlugins.isEmpty()) {
            String message = "missing mandatory plugins [" + String.join((CharSequence)", ", missingPlugins) + "], found plugins [" + String.join((CharSequence)", ", existingPlugins) + "]";
            throw new IllegalStateException(message);
        }
    }

    private static List<PluginRuntimeInfo> getRuntimeInfos(PluginIntrospector inspector, List<PluginDescriptor> pluginDescriptors, Map<String, LoadedPlugin> plugins) {
        ArrayList<PluginRuntimeInfo> runtimeInfos = new ArrayList<PluginRuntimeInfo>();
        for (PluginDescriptor descriptor : pluginDescriptors) {
            LoadedPlugin plugin = plugins.get(descriptor.getName());
            assert (plugin != null);
            Class<?> pluginClazz = plugin.instance.getClass();
            boolean isOfficial = officialPlugins.contains(descriptor.getName());
            PluginApiInfo apiInfo = null;
            if (!isOfficial) {
                apiInfo = new PluginApiInfo(inspector.interfaces(pluginClazz), inspector.overriddenMethods(pluginClazz));
            }
            runtimeInfos.add(new PluginRuntimeInfo(descriptor, isOfficial, apiInfo));
        }
        return runtimeInfos;
    }

    public final <T> Stream<T> map(Function<Plugin, T> function) {
        return this.plugins().stream().map(LoadedPlugin::instance).map(function);
    }

    public final <T> Stream<T> flatMap(Function<Plugin, Collection<T>> function) {
        return this.plugins().stream().map(LoadedPlugin::instance).flatMap((? super T p) -> ((Collection)function.apply((Plugin)p)).stream());
    }

    public final void forEach(Consumer<Plugin> consumer) {
        this.plugins().stream().map(LoadedPlugin::instance).forEach(consumer);
    }

    public final Map<String, Plugin> pluginMap() {
        return this.plugins().stream().collect(Collectors.toMap(p -> p.descriptor().getName(), LoadedPlugin::instance));
    }

    @Override
    public PluginsAndModules info() {
        return this.info;
    }

    protected List<LoadedPlugin> plugins() {
        return this.plugins;
    }

    private Map<String, LoadedPlugin> loadPluginBundles(Settings settings, Path configPath, PluginsLoader pluginsLoader) {
        LinkedHashMap<String, LoadedPlugin> loadedPlugins = new LinkedHashMap<String, LoadedPlugin>();
        pluginsLoader.pluginLayers().forEach((? super T pl) -> this.loadBundle((PluginsLoader.PluginLayer)pl, (Map<String, LoadedPlugin>)loadedPlugins, settings, configPath));
        PluginsService.loadExtensions(loadedPlugins.values());
        return loadedPlugins;
    }

    static void loadExtensions(Collection<LoadedPlugin> plugins) {
        Map extendingPluginsByName = plugins.stream().flatMap((? super T t) -> t.descriptor().getExtendedPlugins().stream().map((? super T extendedPlugin) -> Tuple.tuple((Object)extendedPlugin, (Object)t.instance()))).collect(Collectors.groupingBy(Tuple::v1, Collectors.mapping(Tuple::v2, Collectors.toList())));
        for (LoadedPlugin pluginTuple : plugins) {
            if (!(pluginTuple.instance() instanceof ExtensiblePlugin)) continue;
            PluginsService.loadExtensionsForPlugin((ExtensiblePlugin)((Object)pluginTuple.instance()), extendingPluginsByName.getOrDefault(pluginTuple.descriptor().getName(), List.of()));
        }
    }

    public <T> List<? extends T> loadServiceProviders(Class<T> service) {
        ArrayList<T> result = new ArrayList<T>();
        for (LoadedPlugin pluginTuple : this.plugins()) {
            result.addAll(PluginsService.createExtensions(service, pluginTuple.instance));
        }
        return Collections.unmodifiableList(result);
    }

    public <T> T loadSingletonServiceProvider(Class<T> service, Supplier<T> fallback) {
        List<T> services = this.loadServiceProviders(service);
        if (services.size() > 1) {
            throw new IllegalStateException(String.format(Locale.ROOT, "More than one extension found for %s", service.getSimpleName()));
        }
        if (services.isEmpty()) {
            return fallback.get();
        }
        return services.get(0);
    }

    private static void loadExtensionsForPlugin(ExtensiblePlugin extensiblePlugin, final List<Plugin> extendingPlugins) {
        ExtensiblePlugin.ExtensionLoader extensionLoader = new ExtensiblePlugin.ExtensionLoader(){

            @Override
            public <T> List<T> loadExtensions(Class<T> extensionPointType) {
                ArrayList<T> result = new ArrayList<T>();
                for (Plugin extendingPlugin : extendingPlugins) {
                    result.addAll(PluginsService.createExtensions(extensionPointType, extendingPlugin));
                }
                return Collections.unmodifiableList(result);
            }
        };
        extensiblePlugin.loadExtensions(extensionLoader);
    }

    private static <T> List<? extends T> createExtensions(Class<T> extensionPointType, Plugin plugin) {
        SPIClassIterator<T> classIterator = SPIClassIterator.get(extensionPointType, plugin.getClass().getClassLoader());
        ArrayList<T> extensions = new ArrayList<T>();
        while (classIterator.hasNext()) {
            Object extensionClass = classIterator.next();
            extensions.add(PluginsService.createExtension(extensionClass, extensionPointType, plugin));
        }
        return extensions;
    }

    static <T> T createExtension(Class<? extends T> extensionClass, Class<T> extensionPointType, Plugin plugin) {
        Constructor<?>[] constructors = extensionClass.getConstructors();
        if (constructors.length == 0) {
            throw new IllegalStateException("no public " + PluginsService.extensionConstructorMessage(extensionClass, extensionPointType));
        }
        Constructor<?> constructor = constructors[0];
        if (constructors.length == 2) {
            if (constructors[1].getParameterCount() > 0) {
                constructor = constructors[1];
            }
        } else if (constructors.length > 1) {
            throw new IllegalStateException("no unique public " + PluginsService.extensionConstructorMessage(extensionClass, extensionPointType));
        }
        if (constructor.getParameterCount() > 1) {
            throw new IllegalStateException(PluginsService.extensionSignatureMessage(extensionClass, extensionPointType, plugin));
        }
        if (constructor.getParameterCount() == 1 && constructor.getParameterTypes()[0] != plugin.getClass()) {
            throw new IllegalStateException(PluginsService.extensionSignatureMessage(extensionClass, extensionPointType, plugin) + ", not (" + constructor.getParameterTypes()[0].getName() + ")");
        }
        try {
            if (constructor.getParameterCount() == 0) {
                return (T)constructor.newInstance(new Object[0]);
            }
            return (T)constructor.newInstance(plugin);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("failed to create extension [" + extensionClass.getName() + "] of type [" + extensionPointType.getName() + "]", e);
        }
    }

    private static <T> String extensionSignatureMessage(Class<? extends T> extensionClass, Class<T> extensionPointType, Plugin plugin) {
        return "signature of " + PluginsService.extensionConstructorMessage(extensionClass, extensionPointType) + " must be either () or (" + plugin.getClass().getName() + ")";
    }

    private static <T> String extensionConstructorMessage(Class<? extends T> extensionClass, Class<T> extensionPointType) {
        return "constructor for extension [" + extensionClass.getName() + "] of type [" + extensionPointType.getName() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBundle(PluginsLoader.PluginLayer pluginLayer, Map<String, LoadedPlugin> loadedPlugins, Settings settings, Path configPath) {
        String name = pluginLayer.pluginBundle().plugin.getName();
        logger.debug(() -> "Loading plugin bundle: " + name);
        ArrayList<LoadedPlugin> extendedPlugins = new ArrayList<LoadedPlugin>();
        for (String extendedPluginName : pluginLayer.pluginBundle().plugin.getExtendedPlugins()) {
            LoadedPlugin extendedPlugin = loadedPlugins.get(extendedPluginName);
            assert (extendedPlugin != null);
            if (!ExtensiblePlugin.class.isInstance(extendedPlugin.instance())) {
                throw new IllegalStateException("Plugin [" + name + "] cannot extend non-extensible plugin [" + extendedPluginName + "]");
            }
            extendedPlugins.add(extendedPlugin);
            logger.debug(() -> "Loading plugin bundle: " + name + ", ext plugins: " + String.valueOf(extendedPlugins.stream().map((? super T lp) -> lp.descriptor().getName()).toList()));
        }
        PluginBundle pluginBundle = pluginLayer.pluginBundle();
        ClassLoader pluginClassLoader = pluginLayer.pluginClassLoader();
        PluginsService.reloadLuceneSPI(pluginLayer.pluginClassLoader());
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Plugin plugin;
            Thread.currentThread().setContextClassLoader(pluginLayer.pluginClassLoader());
            if (pluginBundle.pluginDescriptor().isStable()) {
                this.stablePluginsRegistry.scanBundleForStablePlugins(pluginBundle, pluginClassLoader);
                plugin = new StablePluginPlaceHolder(pluginBundle.plugin.getName());
            } else {
                Class<? extends Plugin> pluginClass = PluginsService.loadPluginClass(pluginBundle.plugin.getClassname(), pluginClassLoader);
                if (pluginClassLoader != pluginClass.getClassLoader()) {
                    throw new IllegalStateException("Plugin [" + name + "] must reference a class loader local Plugin class [" + pluginBundle.plugin.getClassname() + "] (class loader [" + String.valueOf(pluginClass.getClassLoader()) + "])");
                }
                plugin = PluginsService.loadPlugin(pluginClass, settings, configPath);
            }
            loadedPlugins.put(name, new LoadedPlugin(pluginBundle.plugin, plugin, pluginLayer.pluginClassLoader()));
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private static void checkDeprecations(PluginIntrospector inspector, List<PluginDescriptor> pluginDescriptors, Map<String, LoadedPlugin> plugins) {
        for (PluginDescriptor descriptor : pluginDescriptors) {
            LoadedPlugin plugin = plugins.get(descriptor.getName());
            Class<?> pluginClazz = plugin.instance.getClass();
            for (String string : inspector.deprecatedInterfaces(pluginClazz)) {
                deprecationLogger.warn(DeprecationCategory.PLUGINS, pluginClazz.getName() + string, "Plugin class {} from plugin {} implements deprecated plugin interface {}. This plugin interface will be removed in a future release.", pluginClazz.getName(), descriptor.getName(), string);
            }
            for (Map.Entry entry : inspector.deprecatedMethods(pluginClazz).entrySet()) {
                String methodName = (String)entry.getKey();
                String interfaceName = (String)entry.getValue();
                deprecationLogger.warn(DeprecationCategory.PLUGINS, pluginClazz.getName() + methodName + interfaceName, "Plugin class {} from plugin {} implements deprecated method {} from plugin interface {}. This method will be removed in a future release.", pluginClazz.getName(), descriptor.getName(), methodName, interfaceName);
            }
        }
    }

    static void reloadLuceneSPI(ClassLoader loader) {
        PostingsFormat.reloadPostingsFormats((ClassLoader)loader);
        DocValuesFormat.reloadDocValuesFormats((ClassLoader)loader);
        KnnVectorsFormat.reloadKnnVectorsFormat((ClassLoader)loader);
        Codec.reloadCodecs((ClassLoader)loader);
    }

    private static Class<? extends Plugin> loadPluginClass(String className, ClassLoader loader) {
        try {
            return Class.forName(className, false, loader).asSubclass(Plugin.class);
        }
        catch (ClassNotFoundException e) {
            throw new ElasticsearchException("Could not find plugin class [" + className + "]", (Throwable)e, new Object[0]);
        }
    }

    static Plugin loadPlugin(Class<? extends Plugin> pluginClass, Settings settings, Path configPath) {
        Constructor<?>[] constructors = pluginClass.getConstructors();
        if (constructors.length == 0) {
            throw new IllegalStateException("no public constructor for [" + pluginClass.getName() + "]");
        }
        if (constructors.length > 1) {
            throw new IllegalStateException("no unique public constructor for [" + pluginClass.getName() + "]");
        }
        Constructor<?> constructor = constructors[0];
        if (constructor.getParameterCount() > 2) {
            throw new IllegalStateException(PluginsService.signatureMessage(pluginClass));
        }
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        try {
            if (constructor.getParameterCount() == 2 && parameterTypes[0] == Settings.class && parameterTypes[1] == Path.class) {
                return (Plugin)constructor.newInstance(settings, configPath);
            }
            if (constructor.getParameterCount() == 1 && parameterTypes[0] == Settings.class) {
                return (Plugin)constructor.newInstance(settings);
            }
            if (constructor.getParameterCount() == 0) {
                return (Plugin)constructor.newInstance(new Object[0]);
            }
            throw new IllegalStateException(PluginsService.signatureMessage(pluginClass));
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("failed to load plugin class [" + pluginClass.getName() + "]", e);
        }
    }

    private static String signatureMessage(Class<? extends Plugin> clazz) {
        return String.format(Locale.ROOT, "no public constructor of correct signature for [%s]; must be [%s], [%s], or [%s]", clazz.getName(), "(org.elasticsearch.common.settings.Settings,java.nio.file.Path)", "(org.elasticsearch.common.settings.Settings)", "()");
    }

    public final <T> Stream<T> filterPlugins(Class<T> type) {
        return this.plugins().stream().filter(x -> type.isAssignableFrom(x.instance().getClass())).map((? super T p) -> p.instance());
    }

    static {
        try (InputStream stream = PluginsService.class.getResourceAsStream("/plugins.txt");){
            officialPlugins = Streams.readAllLines(stream).stream().map(String::trim).collect(Collectors.toUnmodifiableSet());
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    record LoadedPlugin(PluginDescriptor descriptor, Plugin instance, ClassLoader classLoader) {
        LoadedPlugin {
            Objects.requireNonNull(descriptor);
            Objects.requireNonNull(instance);
        }
    }
}

