/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Predicates;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ParserConstructor;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class FieldCapabilities
implements Writeable,
ToXContentObject {
    public static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    public static final ParseField IS_METADATA_FIELD = new ParseField("metadata_field", new String[0]);
    public static final ParseField SEARCHABLE_FIELD = new ParseField("searchable", new String[0]);
    public static final ParseField AGGREGATABLE_FIELD = new ParseField("aggregatable", new String[0]);
    public static final ParseField TIME_SERIES_DIMENSION_FIELD = new ParseField("time_series_dimension", new String[0]);
    public static final ParseField TIME_SERIES_METRIC_FIELD = new ParseField("time_series_metric", new String[0]);
    public static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
    public static final ParseField NON_SEARCHABLE_INDICES_FIELD = new ParseField("non_searchable_indices", new String[0]);
    public static final ParseField NON_AGGREGATABLE_INDICES_FIELD = new ParseField("non_aggregatable_indices", new String[0]);
    public static final ParseField NON_DIMENSION_INDICES_FIELD = new ParseField("non_dimension_indices", new String[0]);
    public static final ParseField METRIC_CONFLICTS_INDICES_FIELD = new ParseField("metric_conflicts_indices", new String[0]);
    private final String name;
    private final String type;
    private final boolean isMetadataField;
    private final boolean isSearchable;
    private final boolean isAggregatable;
    private final boolean isDimension;
    private final TimeSeriesParams.MetricType metricType;
    private final String[] indices;
    private final String[] nonSearchableIndices;
    private final String[] nonAggregatableIndices;
    private final String[] nonDimensionIndices;
    private final String[] metricConflictsIndices;
    private final Map<String, Set<String>> meta;

    public FieldCapabilities(String name, String type, boolean isMetadataField, boolean isSearchable, boolean isAggregatable, boolean isDimension, TimeSeriesParams.MetricType metricType, String[] indices, String[] nonSearchableIndices, String[] nonAggregatableIndices, String[] nonDimensionIndices, String[] metricConflictsIndices, Map<String, Set<String>> meta) {
        this.name = name;
        this.type = type;
        this.isMetadataField = isMetadataField;
        this.isSearchable = isSearchable;
        this.isAggregatable = isAggregatable;
        this.isDimension = isDimension;
        this.metricType = metricType;
        this.indices = indices;
        this.nonSearchableIndices = nonSearchableIndices;
        this.nonAggregatableIndices = nonAggregatableIndices;
        this.nonDimensionIndices = nonDimensionIndices;
        this.metricConflictsIndices = metricConflictsIndices;
        this.meta = Objects.requireNonNull(meta);
    }

    public FieldCapabilities(String name, String type, boolean isMetadataField, boolean isSearchable, boolean isAggregatable, String[] indices, String[] nonSearchableIndices, String[] nonAggregatableIndices, Map<String, Set<String>> meta) {
        this(name, type, isMetadataField, isSearchable, isAggregatable, false, null, indices, nonSearchableIndices, nonAggregatableIndices, null, null, meta);
    }

    @ParserConstructor
    public FieldCapabilities(String name, String type, Boolean isMetadataField, boolean isSearchable, boolean isAggregatable, Boolean isDimension, String metricType, List<String> indices, List<String> nonSearchableIndices, List<String> nonAggregatableIndices, List<String> nonDimensionIndices, List<String> metricConflictsIndices, Map<String, Set<String>> meta) {
        this(name, type, isMetadataField == null ? false : isMetadataField, isSearchable, isAggregatable, isDimension == null ? false : isDimension, metricType != null ? TimeSeriesParams.MetricType.fromString(metricType) : null, indices != null ? indices.toArray(new String[0]) : null, nonSearchableIndices != null ? nonSearchableIndices.toArray(new String[0]) : null, nonAggregatableIndices != null ? nonAggregatableIndices.toArray(new String[0]) : null, nonDimensionIndices != null ? nonDimensionIndices.toArray(new String[0]) : null, metricConflictsIndices != null ? metricConflictsIndices.toArray(new String[0]) : null, meta != null ? meta : Collections.emptyMap());
    }

    FieldCapabilities(StreamInput in) throws IOException {
        this.name = in.readString();
        this.type = in.readString();
        this.isMetadataField = in.readBoolean();
        this.isSearchable = in.readBoolean();
        this.isAggregatable = in.readBoolean();
        this.isDimension = in.readBoolean();
        this.metricType = in.readOptionalEnum(TimeSeriesParams.MetricType.class);
        this.indices = in.readOptionalStringArray();
        this.nonSearchableIndices = in.readOptionalStringArray();
        this.nonAggregatableIndices = in.readOptionalStringArray();
        this.nonDimensionIndices = in.readOptionalStringArray();
        this.metricConflictsIndices = in.readOptionalStringArray();
        this.meta = in.readMap(i -> i.readCollectionAsSet(StreamInput::readString));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.type);
        out.writeBoolean(this.isMetadataField);
        out.writeBoolean(this.isSearchable);
        out.writeBoolean(this.isAggregatable);
        out.writeBoolean(this.isDimension);
        out.writeOptionalEnum(this.metricType);
        out.writeOptionalStringArray(this.indices);
        out.writeOptionalStringArray(this.nonSearchableIndices);
        out.writeOptionalStringArray(this.nonAggregatableIndices);
        out.writeOptionalStringArray(this.nonDimensionIndices);
        out.writeOptionalStringArray(this.metricConflictsIndices);
        out.writeMap(this.meta, StreamOutput::writeStringCollection);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TYPE_FIELD.getPreferredName(), this.type);
        builder.field(IS_METADATA_FIELD.getPreferredName(), this.isMetadataField);
        builder.field(SEARCHABLE_FIELD.getPreferredName(), this.isSearchable);
        builder.field(AGGREGATABLE_FIELD.getPreferredName(), this.isAggregatable);
        if (this.isDimension) {
            builder.field(TIME_SERIES_DIMENSION_FIELD.getPreferredName(), true);
        }
        if (this.metricType != null) {
            builder.field(TIME_SERIES_METRIC_FIELD.getPreferredName(), (Enum)this.metricType);
        }
        if (this.indices != null) {
            builder.array(INDICES_FIELD.getPreferredName(), this.indices);
        }
        if (this.nonSearchableIndices != null) {
            builder.array(NON_SEARCHABLE_INDICES_FIELD.getPreferredName(), this.nonSearchableIndices);
        }
        if (this.nonAggregatableIndices != null) {
            builder.array(NON_AGGREGATABLE_INDICES_FIELD.getPreferredName(), this.nonAggregatableIndices);
        }
        if (this.nonDimensionIndices != null) {
            builder.array(NON_DIMENSION_INDICES_FIELD.getPreferredName(), this.nonDimensionIndices);
        }
        if (this.metricConflictsIndices != null) {
            builder.array(METRIC_CONFLICTS_INDICES_FIELD.getPreferredName(), this.metricConflictsIndices);
        }
        if (!this.meta.isEmpty()) {
            builder.startObject("meta");
            ArrayList<Map.Entry<String, Set<String>>> entries = new ArrayList<Map.Entry<String, Set<String>>>(this.meta.entrySet());
            entries.sort(Map.Entry.comparingByKey());
            for (Map.Entry entry : entries) {
                String[] values = ((Set)entry.getValue()).toArray(Strings.EMPTY_ARRAY);
                Arrays.sort(values, String::compareTo);
                builder.array((String)entry.getKey(), values);
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public String getName() {
        return this.name;
    }

    public boolean isMetadataField() {
        return this.isMetadataField;
    }

    public boolean isAggregatable() {
        return this.isAggregatable;
    }

    public boolean isSearchable() {
        return this.isSearchable;
    }

    public boolean isDimension() {
        return this.isDimension;
    }

    public TimeSeriesParams.MetricType getMetricType() {
        return this.metricType;
    }

    public String getType() {
        return this.type;
    }

    public String[] indices() {
        return this.indices;
    }

    public String[] nonSearchableIndices() {
        return this.nonSearchableIndices;
    }

    public String[] nonAggregatableIndices() {
        return this.nonAggregatableIndices;
    }

    public String[] nonDimensionIndices() {
        return this.nonDimensionIndices;
    }

    public String[] metricConflictsIndices() {
        return this.metricConflictsIndices;
    }

    public Map<String, Set<String>> meta() {
        return this.meta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldCapabilities that = (FieldCapabilities)o;
        return this.isMetadataField == that.isMetadataField && this.isSearchable == that.isSearchable && this.isAggregatable == that.isAggregatable && this.isDimension == that.isDimension && Objects.equals((Object)this.metricType, (Object)that.metricType) && Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Arrays.equals(this.indices, that.indices) && Arrays.equals(this.nonSearchableIndices, that.nonSearchableIndices) && Arrays.equals(this.nonAggregatableIndices, that.nonAggregatableIndices) && Arrays.equals(this.nonDimensionIndices, that.nonDimensionIndices) && Arrays.equals(this.metricConflictsIndices, that.metricConflictsIndices) && Objects.equals(this.meta, that.meta);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.name, this.type, this.isMetadataField, this.isSearchable, this.isAggregatable, this.isDimension, this.metricType, this.meta});
        result = 31 * result + Arrays.hashCode(this.indices);
        result = 31 * result + Arrays.hashCode(this.nonSearchableIndices);
        result = 31 * result + Arrays.hashCode(this.nonAggregatableIndices);
        result = 31 * result + Arrays.hashCode(this.nonDimensionIndices);
        result = 31 * result + Arrays.hashCode(this.metricConflictsIndices);
        return result;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    private record IndexCaps(String[] indices, boolean isSearchable, boolean isAggregatable, boolean isDimension, TimeSeriesParams.MetricType metricType) {
    }

    static class Builder {
        private final String name;
        private final String type;
        private boolean isMetadataField;
        private int searchableIndices = 0;
        private int aggregatableIndices = 0;
        private int dimensionIndices = 0;
        private TimeSeriesParams.MetricType metricType;
        private boolean hasConflictMetricType;
        private final List<IndexCaps> indicesList;
        private final Map<String, Set<String>> meta;
        private int totalIndices;

        Builder(String name, String type) {
            this.name = name;
            this.type = type;
            this.metricType = null;
            this.hasConflictMetricType = false;
            this.indicesList = new ArrayList<IndexCaps>();
            this.meta = new HashMap<String, Set<String>>();
        }

        private boolean assertIndicesSorted(String[] indices) {
            for (int i = 1; i < indices.length; ++i) {
                assert (indices[i - 1].compareTo(indices[i]) < 0) : "indices [" + Arrays.toString(indices) + "] aren't sorted";
            }
            if (!this.indicesList.isEmpty()) {
                IndexCaps lastCaps = this.indicesList.get(this.indicesList.size() - 1);
                String lastIndex = lastCaps.indices[lastCaps.indices.length - 1];
                assert (lastIndex.compareTo(indices[0]) < 0) : "indices aren't sorted; previous [" + lastIndex + "], current [" + indices[0] + "]";
            }
            return true;
        }

        void add(String[] indices, boolean isMetadataField, boolean search, boolean agg, boolean isDimension, TimeSeriesParams.MetricType metricType, Map<String, String> meta) {
            assert (this.assertIndicesSorted(indices));
            this.totalIndices += indices.length;
            if (search) {
                this.searchableIndices += indices.length;
            }
            if (agg) {
                this.aggregatableIndices += indices.length;
            }
            if (isDimension) {
                this.dimensionIndices += indices.length;
            }
            this.isMetadataField |= isMetadataField;
            if (this.indicesList.isEmpty()) {
                this.metricType = metricType;
            } else if (this.metricType != metricType) {
                this.hasConflictMetricType = true;
                this.metricType = null;
            }
            this.indicesList.add(new IndexCaps(indices, search, agg, isDimension, metricType));
            for (Map.Entry<String, String> entry : meta.entrySet()) {
                this.meta.computeIfAbsent(entry.getKey(), key -> new HashSet()).add(entry.getValue());
            }
        }

        void getIndices(Set<String> into) {
            for (int i = 0; i < this.indicesList.size(); ++i) {
                IndexCaps indexCaps = this.indicesList.get(i);
                for (String element : indexCaps.indices) {
                    into.add(element);
                }
            }
        }

        private String[] filterIndices(int length, Predicate<IndexCaps> pred) {
            int index = 0;
            String[] dst = new String[length];
            for (IndexCaps indexCaps : this.indicesList) {
                if (!pred.test(indexCaps)) continue;
                System.arraycopy(indexCaps.indices, 0, dst, index, indexCaps.indices.length);
                index += indexCaps.indices.length;
            }
            assert (index == length) : index + "!=" + length;
            return dst;
        }

        FieldCapabilities build(boolean withIndices) {
            String[] indices = withIndices ? this.filterIndices(this.totalIndices, Predicates.always()) : null;
            boolean isSearchable = this.searchableIndices == this.totalIndices;
            String[] nonSearchableIndices = isSearchable || this.searchableIndices == 0 ? null : this.filterIndices(this.totalIndices - this.searchableIndices, ic -> !ic.isSearchable);
            boolean isAggregatable = this.aggregatableIndices == this.totalIndices;
            String[] nonAggregatableIndices = isAggregatable || this.aggregatableIndices == 0 ? null : this.filterIndices(this.totalIndices - this.aggregatableIndices, ic -> !ic.isAggregatable);
            boolean isDimension = this.dimensionIndices == this.totalIndices;
            String[] nonDimensionIndices = isDimension || this.dimensionIndices == 0 ? null : this.filterIndices(this.totalIndices - this.dimensionIndices, ic -> !ic.isDimension);
            String[] metricConflictsIndices = this.hasConflictMetricType ? Objects.requireNonNullElseGet(indices, () -> this.filterIndices(this.totalIndices, Predicates.always())) : null;
            Function<Map.Entry, Set> entryValueFunction = Map.Entry::getValue;
            Map<String, Set<String>> immutableMeta = this.meta.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, entryValueFunction.andThen(Set::copyOf)));
            return new FieldCapabilities(this.name, this.type, this.isMetadataField, isSearchable, isAggregatable, isDimension, this.metricType, indices, nonSearchableIndices, nonAggregatableIndices, nonDimensionIndices, metricConflictsIndices, immutableMeta);
        }
    }
}

