/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.get.shard;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.ShardSnapshotInfo;

public class GetShardSnapshotResponse
extends ActionResponse {
    public static final GetShardSnapshotResponse EMPTY = new GetShardSnapshotResponse(null, Collections.emptyMap());
    private final ShardSnapshotInfo latestShardSnapshot;
    private final Map<String, RepositoryException> repositoryFailures;

    GetShardSnapshotResponse(@Nullable ShardSnapshotInfo latestShardSnapshot, Map<String, RepositoryException> repositoryFailures) {
        this.latestShardSnapshot = latestShardSnapshot;
        this.repositoryFailures = repositoryFailures;
    }

    GetShardSnapshotResponse(StreamInput in) throws IOException {
        this.latestShardSnapshot = in.readOptionalWriteable(ShardSnapshotInfo::new);
        this.repositoryFailures = in.readMap(RepositoryException::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.latestShardSnapshot);
        out.writeMap(this.repositoryFailures, StreamOutput::writeWriteable);
    }

    public Optional<RepositoryException> getFailureForRepository(String repository) {
        return Optional.ofNullable(this.repositoryFailures.get(repository));
    }

    public Optional<ShardSnapshotInfo> getLatestShardSnapshot() {
        return Optional.ofNullable(this.latestShardSnapshot);
    }

    public Map<String, RepositoryException> getRepositoryFailures() {
        return this.repositoryFailures;
    }
}

