/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.support;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.util.concurrent.ReleasableLock;

public class InvalidationCountingCacheWrapper<K, V> {
    private static final Logger logger = LogManager.getLogger(InvalidationCountingCacheWrapper.class);
    private final Cache<K, V> delegate;
    private final AtomicLong numInvalidation = new AtomicLong();
    private final ReadWriteLock invalidationLock = new ReentrantReadWriteLock();
    private final ReleasableLock invalidationReadLock = new ReleasableLock(this.invalidationLock.readLock());
    private final ReleasableLock invalidationWriteLock = new ReleasableLock(this.invalidationLock.writeLock());

    public InvalidationCountingCacheWrapper(Cache<K, V> delegate) {
        this.delegate = delegate;
    }

    public long getInvalidationCount() {
        return this.numInvalidation.get();
    }

    public boolean putIfNoInvalidationSince(K key, V value, long invalidationCount) {
        assert (invalidationCount >= 0L) : "Invalidation count must be non-negative";
        try (ReleasableLock ignored = this.invalidationReadLock.acquire();){
            if (invalidationCount == this.numInvalidation.get()) {
                logger.debug("Caching for key [{}], value [{}]", key, value);
                this.delegate.put(key, value);
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public V get(K key) {
        return (V)this.delegate.get(key);
    }

    public void invalidate(Collection<K> keys) {
        try (ReleasableLock ignored = this.invalidationWriteLock.acquire();){
            this.numInvalidation.incrementAndGet();
        }
        logger.debug("Invalidating for keys [{}]", keys);
        keys.forEach(arg_0 -> this.delegate.invalidate(arg_0));
    }

    public void invalidateAll() {
        try (ReleasableLock ignored = this.invalidationWriteLock.acquire();){
            this.numInvalidation.incrementAndGet();
        }
        logger.debug("Invalidating all cache entries");
        this.delegate.invalidateAll();
    }

    public int count() {
        return this.delegate.count();
    }
}

