/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.elasticsearch.xpack.sql.proto.content;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import shadow.fasterxml.jackson.core.JsonLocation;
import shadow.fasterxml.jackson.core.JsonParser;
import shadow.org.elasticsearch.xpack.sql.proto.content.AbstractObjectParser;
import shadow.org.elasticsearch.xpack.sql.proto.content.ObjectParser;
import shadow.org.elasticsearch.xpack.sql.proto.content.ParseException;
import shadow.org.elasticsearch.xpack.sql.proto.content.ParserUtils;

public class ConstructingObjectParser<Value, Context>
extends AbstractObjectParser<Value, Context> {
    private static final BiConsumer<?, ?> REQUIRED_CONSTRUCTOR_ARG_MARKER = (a, b) -> {
        throw new UnsupportedOperationException("I am just a marker I should never be called.");
    };
    private static final BiConsumer<?, ?> OPTIONAL_CONSTRUCTOR_ARG_MARKER = (a, b) -> {
        throw new UnsupportedOperationException("I am just a marker I should never be called.");
    };
    private final List<ConstructorArgInfo> constructorArgInfos = new ArrayList<ConstructorArgInfo>();
    private final ObjectParser<Target, Context> objectParser;
    private final BiFunction<Object[], Context, Value> builder;
    private int numberOfFields = 0;

    public static <Value, FieldT> BiConsumer<Value, FieldT> constructorArg() {
        return REQUIRED_CONSTRUCTOR_ARG_MARKER;
    }

    public static <Value, FieldT> BiConsumer<Value, FieldT> optionalConstructorArg() {
        return OPTIONAL_CONSTRUCTOR_ARG_MARKER;
    }

    public ConstructingObjectParser(String name, boolean ignoreUnknownFields, Function<Object[], Value> builder) {
        this(name, ignoreUnknownFields, (Object[] args, Context context) -> builder.apply((Object[])args));
    }

    public ConstructingObjectParser(String name, boolean ignoreUnknownFields, BiFunction<Object[], Context, Value> builder) {
        this.objectParser = new ObjectParser(name, ignoreUnknownFields, null);
        this.builder = builder;
    }

    @Override
    public <T> void declareField(BiConsumer<Value, T> consumer, AbstractObjectParser.ContextParser<Context, T> parser, String field, AbstractObjectParser.ValueType type) {
        if (consumer == null) {
            throw new IllegalArgumentException("[consumer] is required");
        }
        if (parser == null) {
            throw new IllegalArgumentException("[parser] is required");
        }
        if (field == null) {
            throw new IllegalArgumentException("[parseField] is required");
        }
        if (type == null) {
            throw new IllegalArgumentException("[type] is required");
        }
        if (ConstructingObjectParser.isConstructorArg(consumer)) {
            int position = this.addConstructorArg(consumer, field);
            this.objectParser.declareField((Value target, T v) -> ((Target)target).constructorArg(position, v), parser, field, type);
        } else {
            ++this.numberOfFields;
            this.objectParser.declareField(this.queueingConsumer(consumer, field), parser, field, type);
        }
    }

    private <T> BiConsumer<Target, T> queueingConsumer(BiConsumer<Value, T> consumer, String parseField) {
        return (target, v) -> {
            if (((Target)target).targetObject != null) {
                consumer.accept(((Target)target).targetObject, v);
                return;
            }
            JsonLocation location = ((Target)target).parser.getTokenLocation();
            ((Target)target).queue(targetObject -> {
                try {
                    consumer.accept(targetObject, v);
                }
                catch (Exception e) {
                    throw new ParseException(ParserUtils.location(location), "[" + this.objectParser.getName() + "] failed to parse field [" + parseField + "]", e);
                }
            });
        };
    }

    private static boolean isConstructorArg(BiConsumer<?, ?> consumer) {
        return consumer == REQUIRED_CONSTRUCTOR_ARG_MARKER || consumer == OPTIONAL_CONSTRUCTOR_ARG_MARKER;
    }

    private int addConstructorArg(BiConsumer<?, ?> consumer, String field) {
        this.constructorArgInfos.add(new ConstructorArgInfo(field, consumer == REQUIRED_CONSTRUCTOR_ARG_MARKER));
        return this.constructorArgInfos.size() - 1;
    }

    @Override
    Value parse(JsonParser parser, Context context) throws IOException {
        return (Value)this.objectParser.parse(parser, new Target(parser, context), context).finish();
    }

    private static class ConstructorArgInfo {
        final String field;
        final boolean required;

        ConstructorArgInfo(String field, boolean required) {
            this.field = field;
            this.required = required;
        }
    }

    private class Target {
        private final Object[] constructorArgs;
        private final JsonParser parser;
        private final Context context;
        private int constructorArgsCollected = 0;
        private Consumer<Value>[] queuedFields;
        private Consumer<Value> queuedOrderedModeCallback;
        private int queuedFieldsCount = 0;
        private Value targetObject;

        Target(JsonParser parser, Context context) {
            this.parser = parser;
            this.context = context;
            this.constructorArgs = new Object[ConstructingObjectParser.this.constructorArgInfos.size()];
        }

        private void constructorArg(int position, Object value) {
            this.constructorArgs[position] = value;
            ++this.constructorArgsCollected;
            if (this.constructorArgsCollected == ConstructingObjectParser.this.constructorArgInfos.size()) {
                this.buildTarget();
            }
        }

        private void queue(Consumer<Value> queueMe) {
            assert (this.targetObject == null) : "Don't queue after the targetObject has been built! Just apply the consumer directly.";
            if (this.queuedFields == null) {
                this.queuedFields = new Consumer[ConstructingObjectParser.this.numberOfFields];
            }
            this.queuedFields[this.queuedFieldsCount] = queueMe;
            ++this.queuedFieldsCount;
        }

        private Value finish() {
            if (this.targetObject != null) {
                return this.targetObject;
            }
            StringBuilder message = null;
            for (int i = 0; i < this.constructorArgs.length; ++i) {
                if (this.constructorArgs[i] != null) continue;
                ConstructorArgInfo arg = (ConstructorArgInfo)ConstructingObjectParser.this.constructorArgInfos.get(i);
                if (!arg.required) continue;
                if (message == null) {
                    message = new StringBuilder("Required [").append(arg.field);
                    continue;
                }
                message.append(", ").append(arg.field);
            }
            if (message != null) {
                throw new IllegalArgumentException(message.append(']').toString());
            }
            if (ConstructingObjectParser.this.constructorArgInfos.isEmpty()) {
                throw new ParseException("[" + ConstructingObjectParser.this.objectParser.getName() + "] must configure at least one constructor argument. If it doesn't have any it should use ObjectParser instead of ConstructingObjectParser. This is a bug in the parser declaration.");
            }
            this.buildTarget();
            return this.targetObject;
        }

        private void buildTarget() {
            try {
                this.targetObject = ConstructingObjectParser.this.builder.apply(this.constructorArgs, this.context);
                if (this.queuedOrderedModeCallback != null) {
                    this.queuedOrderedModeCallback.accept(this.targetObject);
                }
                while (this.queuedFieldsCount > 0) {
                    --this.queuedFieldsCount;
                    this.queuedFields[this.queuedFieldsCount].accept(this.targetObject);
                }
            }
            catch (ParseException e) {
                throw new ParseException(e.location(), "failed to build [" + ConstructingObjectParser.this.objectParser.getName() + "] after last required field arrived", e);
            }
            catch (Exception e) {
                throw new ParseException(null, "Failed to build [" + ConstructingObjectParser.this.objectParser.getName() + "] after last required field arrived", e);
            }
        }
    }
}

