/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.compute.aggregation.AbstractArrayState;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.LongLongState;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class FirstLongByTimestampAggregator {
    public static String describe() {
        return "first_long_by_timestamp";
    }

    public static LongLongState initSingle(DriverContext driverContext) {
        return new LongLongState(0L, 0L);
    }

    public static void first(LongLongState current, long value, long timestamp) {
        current.v1(timestamp);
        current.v2(value);
    }

    public static void combine(LongLongState current, long value, long timestamp) {
        if (timestamp < current.v1()) {
            current.v1(timestamp);
            current.v2(value);
        }
    }

    public static void combineIntermediate(LongLongState current, long timestamp, long value, boolean seen) {
        if (seen) {
            if (current.seen()) {
                FirstLongByTimestampAggregator.combine(current, value, timestamp);
            } else {
                FirstLongByTimestampAggregator.first(current, value, timestamp);
                current.seen(true);
            }
        }
    }

    public static Block evaluateFinal(LongLongState current, DriverContext ctx) {
        return ctx.blockFactory().newConstantLongBlockWith(current.v2(), 1);
    }

    public static GroupingState initGrouping(DriverContext driverContext) {
        return new GroupingState(driverContext.bigArrays());
    }

    public static void combine(GroupingState current, int groupId, long value, long timestamp) {
        current.collectValue(groupId, timestamp, value);
    }

    public static void combineIntermediate(GroupingState current, int groupId, LongBlock timestamps, LongBlock values, int otherPosition) {
        int valueCount = values.getValueCount(otherPosition);
        if (valueCount > 0) {
            long timestamp = timestamps.getLong(timestamps.getFirstValueIndex(otherPosition));
            int firstIndex = values.getFirstValueIndex(otherPosition);
            for (int i = 0; i < valueCount; ++i) {
                current.collectValue(groupId, timestamp, values.getLong(firstIndex + i));
            }
        }
    }

    public static Block evaluateFinal(GroupingState state, IntVector selected, GroupingAggregatorEvaluationContext ctx) {
        return state.evaluateFinal(selected, ctx);
    }

    public static final class GroupingState
    extends AbstractArrayState {
        private final BigArrays bigArrays;
        private LongArray timestamps;
        private LongArray values;
        private int maxGroupId = -1;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        GroupingState(BigArrays bigArrays) {
            super(bigArrays);
            this.bigArrays = bigArrays;
            boolean success = false;
            LongArray timestamps = null;
            try {
                this.timestamps = timestamps = bigArrays.newLongArray(1L, false);
                this.values = bigArrays.newLongArray(1L, false);
                this.enableGroupIdTracking(new SeenGroupIds.Empty());
                return;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                Releasables.close((Releasable[])new Releasable[]{timestamps, this.values, () -> super.close()});
                throw throwable;
            }
        }

        void collectValue(int groupId, long timestamp, long value) {
            boolean updated = false;
            if ((long)groupId < this.timestamps.size()) {
                if (groupId > this.maxGroupId || !this.hasValue(groupId) || this.timestamps.get((long)groupId) > timestamp) {
                    this.timestamps.set((long)groupId, timestamp);
                    updated = true;
                }
            } else {
                this.timestamps = this.bigArrays.grow(this.timestamps, (long)(groupId + 1));
                this.timestamps.set((long)groupId, timestamp);
                updated = true;
            }
            if (updated) {
                this.values = this.bigArrays.grow(this.values, (long)(groupId + 1));
                this.values.set((long)groupId, value);
            }
            this.maxGroupId = Math.max(this.maxGroupId, groupId);
            this.trackGroupId(groupId);
        }

        @Override
        public void close() {
            Releasables.close((Releasable[])new Releasable[]{this.timestamps, this.values, () -> super.close()});
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
            try (LongBlock.Builder timestampsBuilder = driverContext.blockFactory().newLongBlockBuilder(selected.getPositionCount());
                 LongBlock.Builder valuesBuilder = driverContext.blockFactory().newLongBlockBuilder(selected.getPositionCount());){
                for (int p = 0; p < selected.getPositionCount(); ++p) {
                    int group = selected.getInt(p);
                    if ((long)group < this.timestamps.size() && this.hasValue(group)) {
                        timestampsBuilder.appendLong(this.timestamps.get((long)group));
                        valuesBuilder.appendLong(this.values.get((long)group));
                        continue;
                    }
                    timestampsBuilder.appendNull();
                    valuesBuilder.appendNull();
                }
                blocks[offset] = timestampsBuilder.build();
                blocks[offset + 1] = valuesBuilder.build();
            }
        }

        Block evaluateFinal(IntVector selected, GroupingAggregatorEvaluationContext evalContext) {
            try (LongBlock.Builder builder = evalContext.blockFactory().newLongBlockBuilder(selected.getPositionCount());){
                for (int p = 0; p < selected.getPositionCount(); ++p) {
                    int group = selected.getInt(p);
                    if ((long)group < this.timestamps.size() && this.hasValue(group)) {
                        builder.appendLong(this.values.get((long)group));
                        continue;
                    }
                    builder.appendNull();
                }
                LongBlock longBlock = builder.build();
                return longBlock;
            }
        }
    }
}

