/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.Now;

public final class NowEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(NowEvaluator.class);
    private final Source source;
    private final long now;
    private final DriverContext driverContext;
    private Warnings warnings;

    public NowEvaluator(Source source, long now, DriverContext driverContext) {
        this.source = source;
        this.now = now;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        return this.eval(page.getPositionCount()).asBlock();
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed;
    }

    public LongVector eval(int positionCount) {
        try (LongVector.FixedBuilder result = this.driverContext.blockFactory().newLongVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                result.appendLong(p, Now.process(this.now));
            }
            LongVector longVector = result.build();
            return longVector;
        }
    }

    public String toString() {
        return "NowEvaluator[now=" + this.now + "]";
    }

    public void close() {
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final long now;

        public Factory(Source source, long now) {
            this.source = source;
            this.now = now;
        }

        public NowEvaluator get(DriverContext context) {
            return new NowEvaluator(this.source, this.now, context);
        }

        public String toString() {
            return "NowEvaluator[now=" + this.now + "]";
        }
    }
}

