/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.ec2;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.discovery.SeedHostsProvider;
import org.elasticsearch.discovery.ec2.AwsEc2SeedHostsProvider;
import org.elasticsearch.discovery.ec2.AwsEc2Service;
import org.elasticsearch.discovery.ec2.AwsEc2ServiceImpl;
import org.elasticsearch.discovery.ec2.AwsEc2Utils;
import org.elasticsearch.discovery.ec2.Ec2ClientSettings;
import org.elasticsearch.discovery.ec2.Ec2NameResolver;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.node.Node;
import org.elasticsearch.plugins.DiscoveryPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.ReloadablePlugin;
import org.elasticsearch.transport.TransportService;

public class Ec2DiscoveryPlugin
extends Plugin
implements DiscoveryPlugin,
ReloadablePlugin {
    private static final Logger logger = LogManager.getLogger(Ec2DiscoveryPlugin.class);
    public static final String EC2_SEED_HOSTS_PROVIDER_NAME = "ec2";
    private final Settings settings;
    protected final AwsEc2Service ec2Service;
    private static final String IMDS_AVAILABILITY_ZONE_PATH = "/latest/meta-data/placement/availability-zone";

    public Ec2DiscoveryPlugin(Settings settings) {
        this(settings, new AwsEc2ServiceImpl());
    }

    protected Ec2DiscoveryPlugin(Settings settings, AwsEc2ServiceImpl ec2Service) {
        this.settings = settings;
        this.ec2Service = ec2Service;
        this.reload(settings);
    }

    public NetworkService.CustomNameResolver getCustomNameResolver(Settings _settings) {
        logger.debug("Register _ec2_, _ec2:xxx_ network names");
        return new Ec2NameResolver();
    }

    public Map<String, Supplier<SeedHostsProvider>> getSeedHostProviders(TransportService transportService, NetworkService networkService) {
        return Map.of(EC2_SEED_HOSTS_PROVIDER_NAME, () -> new AwsEc2SeedHostsProvider(this.settings, transportService, this.ec2Service));
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(Ec2ClientSettings.ACCESS_KEY_SETTING, Ec2ClientSettings.SECRET_KEY_SETTING, Ec2ClientSettings.SESSION_TOKEN_SETTING, Ec2ClientSettings.ENDPOINT_SETTING, Ec2ClientSettings.PROTOCOL_SETTING, Ec2ClientSettings.PROXY_HOST_SETTING, Ec2ClientSettings.PROXY_PORT_SETTING, Ec2ClientSettings.PROXY_SCHEME_SETTING, Ec2ClientSettings.PROXY_USERNAME_SETTING, Ec2ClientSettings.PROXY_PASSWORD_SETTING, Ec2ClientSettings.READ_TIMEOUT_SETTING, AwsEc2Service.HOST_TYPE_SETTING, AwsEc2Service.ANY_GROUP_SETTING, AwsEc2Service.GROUPS_SETTING, AwsEc2Service.AVAILABILITY_ZONES_SETTING, AwsEc2Service.NODE_CACHE_TIME_SETTING, AwsEc2Service.TAG_SETTING, AwsEc2Service.AUTO_ATTRIBUTE_SETTING);
    }

    public Settings additionalSettings() {
        return Ec2DiscoveryPlugin.getAvailabilityZoneNodeAttributes(this.settings);
    }

    static Settings getAvailabilityZoneNodeAttributes(Settings settings) {
        if (((Boolean)AwsEc2Service.AUTO_ATTRIBUTE_SETTING.get(settings)).booleanValue()) {
            try {
                return Settings.builder().put(Node.NODE_ATTRIBUTES.getKey() + "aws_availability_zone", AwsEc2Utils.getInstanceMetadata(IMDS_AVAILABILITY_ZONE_PATH)).build();
            }
            catch (Exception e) {
                logger.error("failed to get metadata for [placement/availability-zone]", (Throwable)e);
            }
        }
        return Settings.EMPTY;
    }

    public void close() throws IOException {
        this.ec2Service.close();
    }

    public void reload(Settings settingsToLoad) {
        this.ec2Service.refreshAndClearCache(Ec2ClientSettings.getClientSettings(settingsToLoad));
    }

    static {
        SpecialPermission.check();
    }
}

