/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map;

import java.text.DateFormat;
import java.util.HashMap;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.AnnotationIntrospector;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.BeanDescription;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.ClassIntrospector;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.HandlerInstantiator;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.JsonSerializer;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.MapperConfig;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.PropertyNamingStrategy;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.annotate.JsonSerialize;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.introspect.Annotated;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.introspect.AnnotatedClass;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.introspect.VisibilityChecker;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.jsontype.SubtypeResolver;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.jsontype.TypeResolverBuilder;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.ser.FilterProvider;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.type.ClassKey;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.type.TypeFactory;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.util.ClassUtil;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializationConfig
extends MapperConfig<SerializationConfig> {
    protected static final int DEFAULT_FEATURE_FLAGS = Feature.collectDefaults();
    protected int _featureFlags = DEFAULT_FEATURE_FLAGS;
    protected JsonSerialize.Inclusion _serializationInclusion = null;
    protected Class<?> _serializationView;
    protected FilterProvider _filterProvider;

    public SerializationConfig(ClassIntrospector<? extends BeanDescription> intr, AnnotationIntrospector annIntr, VisibilityChecker<?> vc, SubtypeResolver subtypeResolver, PropertyNamingStrategy propertyNamingStrategy, TypeFactory typeFactory, HandlerInstantiator handlerInstantiator) {
        super(intr, annIntr, vc, subtypeResolver, propertyNamingStrategy, typeFactory, handlerInstantiator);
        this._filterProvider = null;
    }

    protected SerializationConfig(SerializationConfig src) {
        this(src, src._base);
    }

    protected SerializationConfig(SerializationConfig src, HashMap<ClassKey, Class<?>> mixins, SubtypeResolver str) {
        this(src, src._base);
        this._mixInAnnotations = mixins;
        this._subtypeResolver = str;
    }

    protected SerializationConfig(SerializationConfig src, MapperConfig.Base base) {
        super(src, base, src._subtypeResolver);
        this._featureFlags = src._featureFlags;
        this._serializationInclusion = src._serializationInclusion;
        this._serializationView = src._serializationView;
        this._filterProvider = src._filterProvider;
    }

    protected SerializationConfig(SerializationConfig src, FilterProvider filters) {
        super(src);
        this._featureFlags = src._featureFlags;
        this._serializationInclusion = src._serializationInclusion;
        this._serializationView = src._serializationView;
        this._filterProvider = filters;
    }

    protected SerializationConfig(SerializationConfig src, Class<?> view) {
        super(src);
        this._featureFlags = src._featureFlags;
        this._serializationInclusion = src._serializationInclusion;
        this._serializationView = view;
        this._filterProvider = src._filterProvider;
    }

    @Override
    public SerializationConfig withClassIntrospector(ClassIntrospector<? extends BeanDescription> ci) {
        return new SerializationConfig(this, this._base.withClassIntrospector(ci));
    }

    @Override
    public SerializationConfig withAnnotationIntrospector(AnnotationIntrospector ai) {
        return new SerializationConfig(this, this._base.withAnnotationIntrospector(ai));
    }

    @Override
    public SerializationConfig withVisibilityChecker(VisibilityChecker<?> vc) {
        return new SerializationConfig(this, this._base.withVisibilityChecker(vc));
    }

    @Override
    public SerializationConfig withTypeResolverBuilder(TypeResolverBuilder<?> trb) {
        return new SerializationConfig(this, this._base.withTypeResolverBuilder(trb));
    }

    @Override
    public SerializationConfig withSubtypeResolver(SubtypeResolver str) {
        SerializationConfig cfg = new SerializationConfig(this);
        cfg._subtypeResolver = str;
        return cfg;
    }

    @Override
    public SerializationConfig withPropertyNamingStrategy(PropertyNamingStrategy pns) {
        return new SerializationConfig(this, this._base.withPropertyNamingStrategy(pns));
    }

    @Override
    public SerializationConfig withTypeFactory(TypeFactory tf) {
        return new SerializationConfig(this, this._base.withTypeFactory(tf));
    }

    @Override
    public SerializationConfig withDateFormat(DateFormat df) {
        SerializationConfig cfg = new SerializationConfig(this, this._base.withDateFormat(df));
        cfg.set(Feature.WRITE_DATES_AS_TIMESTAMPS, df == null);
        return cfg;
    }

    @Override
    public SerializationConfig withHandlerInstantiator(HandlerInstantiator hi) {
        return new SerializationConfig(this, this._base.withHandlerInstantiator(hi));
    }

    public SerializationConfig withFilters(FilterProvider filterProvider) {
        return new SerializationConfig(this, filterProvider);
    }

    public SerializationConfig withView(Class<?> view) {
        return new SerializationConfig(this, view);
    }

    @Override
    public void fromAnnotations(Class<?> cls) {
        JsonSerialize.Typing typing;
        AnnotationIntrospector ai = this.getAnnotationIntrospector();
        AnnotatedClass ac = AnnotatedClass.construct(cls, ai, null);
        this._base = this._base.withVisibilityChecker(ai.findAutoDetectVisibility(ac, this.getDefaultVisibilityChecker()));
        JsonSerialize.Inclusion incl = ai.findSerializationInclusion(ac, null);
        if (incl != this._serializationInclusion) {
            this.setSerializationInclusion(incl);
        }
        if ((typing = ai.findSerializationTyping(ac)) != null) {
            this.set(Feature.USE_STATIC_TYPING, typing == JsonSerialize.Typing.STATIC);
        }
    }

    @Override
    public SerializationConfig createUnshared(SubtypeResolver subtypeResolver) {
        HashMap mixins = this._mixInAnnotations;
        this._mixInAnnotationsShared = true;
        return new SerializationConfig(this, mixins, subtypeResolver);
    }

    @Override
    public AnnotationIntrospector getAnnotationIntrospector() {
        if (this.isEnabled(Feature.USE_ANNOTATIONS)) {
            return super.getAnnotationIntrospector();
        }
        return AnnotationIntrospector.nopInstance();
    }

    @Override
    public <T extends BeanDescription> T introspectClassAnnotations(Class<?> cls) {
        return (T)this.getClassIntrospector().forClassAnnotations(this, cls, this);
    }

    @Override
    public <T extends BeanDescription> T introspectDirectClassAnnotations(Class<?> cls) {
        return (T)this.getClassIntrospector().forDirectClassAnnotations(this, cls, this);
    }

    @Override
    public boolean isAnnotationProcessingEnabled() {
        return this.isEnabled(Feature.USE_ANNOTATIONS);
    }

    @Override
    public boolean canOverrideAccessModifiers() {
        return this.isEnabled(Feature.CAN_OVERRIDE_ACCESS_MODIFIERS);
    }

    public void enable(Feature f) {
        this._featureFlags |= f.getMask();
    }

    public void disable(Feature f) {
        this._featureFlags &= ~f.getMask();
    }

    public void set(Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
    }

    public final boolean isEnabled(Feature f) {
        return (this._featureFlags & f.getMask()) != 0;
    }

    public Class<?> getSerializationView() {
        return this._serializationView;
    }

    public JsonSerialize.Inclusion getSerializationInclusion() {
        if (this._serializationInclusion != null) {
            return this._serializationInclusion;
        }
        return this.isEnabled(Feature.WRITE_NULL_PROPERTIES) ? JsonSerialize.Inclusion.ALWAYS : JsonSerialize.Inclusion.NON_NULL;
    }

    public void setSerializationInclusion(JsonSerialize.Inclusion props) {
        this._serializationInclusion = props;
        if (props == JsonSerialize.Inclusion.NON_NULL) {
            this.disable(Feature.WRITE_NULL_PROPERTIES);
        } else {
            this.enable(Feature.WRITE_NULL_PROPERTIES);
        }
    }

    public FilterProvider getFilterProvider() {
        return this._filterProvider;
    }

    public <T extends BeanDescription> T introspect(JavaType type) {
        return (T)this.getClassIntrospector().forSerialization(this, type, this);
    }

    public JsonSerializer<Object> serializerInstance(Annotated annotated, Class<? extends JsonSerializer<?>> serClass) {
        JsonSerializer<Object> ser;
        HandlerInstantiator hi = this.getHandlerInstantiator();
        if (hi != null && (ser = hi.serializerInstance(this, annotated, serClass)) != null) {
            return ser;
        }
        return ClassUtil.createInstance(serClass, this.canOverrideAccessModifiers());
    }

    @Override
    @Deprecated
    public SerializationConfig createUnshared(TypeResolverBuilder<?> typer, VisibilityChecker<?> vc, SubtypeResolver str) {
        return ((SerializationConfig)this.createUnshared(str).withTypeResolverBuilder((TypeResolverBuilder)typer)).withVisibilityChecker((VisibilityChecker)vc);
    }

    @Override
    @Deprecated
    public final void setDateFormat(DateFormat df) {
        super.setDateFormat(df);
        this.set(Feature.WRITE_DATES_AS_TIMESTAMPS, df == null);
    }

    @Deprecated
    public void setSerializationView(Class<?> view) {
        this._serializationView = view;
    }

    public String toString() {
        return "[SerializationConfig: flags=0x" + Integer.toHexString(this._featureFlags) + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Feature {
        USE_ANNOTATIONS(true),
        AUTO_DETECT_GETTERS(true),
        AUTO_DETECT_IS_GETTERS(true),
        AUTO_DETECT_FIELDS(true),
        CAN_OVERRIDE_ACCESS_MODIFIERS(true),
        WRITE_NULL_PROPERTIES(true),
        USE_STATIC_TYPING(false),
        DEFAULT_VIEW_INCLUSION(true),
        WRAP_ROOT_VALUE(false),
        INDENT_OUTPUT(false),
        SORT_PROPERTIES_ALPHABETICALLY(false),
        FAIL_ON_EMPTY_BEANS(true),
        WRAP_EXCEPTIONS(true),
        CLOSE_CLOSEABLE(false),
        FLUSH_AFTER_WRITE_VALUE(true),
        WRITE_DATES_AS_TIMESTAMPS(true),
        WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS(false),
        WRITE_ENUMS_USING_TO_STRING(false),
        WRITE_NULL_MAP_VALUES(true);

        final boolean _defaultState;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return 1 << this.ordinal();
        }
    }
}

