/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.deser.impl;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Collection;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.JsonParser;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.JsonProcessingException;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.JsonToken;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.DeserializationConfig;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.DeserializationContext;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.JsonDeserializer;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.TypeDeserializer;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.annotate.JacksonStdImpl;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.deser.ContainerDeserializer;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JacksonStdImpl
public final class StringCollectionDeserializer
extends ContainerDeserializer<Collection<String>> {
    protected final JavaType _collectionType;
    protected final JsonDeserializer<String> _valueDeserializer;
    protected final boolean _isDefaultDeserializer;
    final Constructor<Collection<String>> _defaultCtor;

    public StringCollectionDeserializer(JavaType collectionType, JsonDeserializer<?> valueDeser, Constructor<?> ctor) {
        super(collectionType.getRawClass());
        this._collectionType = collectionType;
        this._valueDeserializer = valueDeser;
        this._defaultCtor = ctor;
        this._isDefaultDeserializer = this.isDefaultSerializer(valueDeser);
    }

    @Override
    public JavaType getContentType() {
        return this._collectionType.getContentType();
    }

    @Override
    public JsonDeserializer<Object> getContentDeserializer() {
        JsonDeserializer<Object> deser = this._valueDeserializer;
        return deser;
    }

    @Override
    public Collection<String> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Collection<String> result;
        try {
            result = this._defaultCtor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw ctxt.instantiationException(this._collectionType.getRawClass(), e);
        }
        return this.deserialize(jp, ctxt, result);
    }

    @Override
    public Collection<String> deserialize(JsonParser jp, DeserializationContext ctxt, Collection<String> result) throws IOException, JsonProcessingException {
        JsonToken t;
        if (!jp.isExpectedStartArrayToken()) {
            return this.handleNonArray(jp, ctxt, result);
        }
        if (!this._isDefaultDeserializer) {
            return this.deserializeUsingCustom(jp, ctxt, result);
        }
        while ((t = jp.nextToken()) != JsonToken.END_ARRAY) {
            result.add(t == JsonToken.VALUE_NULL ? null : jp.getText());
        }
        return result;
    }

    private Collection<String> deserializeUsingCustom(JsonParser jp, DeserializationContext ctxt, Collection<String> result) throws IOException, JsonProcessingException {
        JsonToken t;
        JsonDeserializer<String> deser = this._valueDeserializer;
        while ((t = jp.nextToken()) != JsonToken.END_ARRAY) {
            String value = t == JsonToken.VALUE_NULL ? null : deser.deserialize(jp, ctxt);
            result.add(value);
        }
        return result;
    }

    @Override
    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return typeDeserializer.deserializeTypedFromArray(jp, ctxt);
    }

    private final Collection<String> handleNonArray(JsonParser jp, DeserializationContext ctxt, Collection<String> result) throws IOException, JsonProcessingException {
        if (!ctxt.isEnabled(DeserializationConfig.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY)) {
            throw ctxt.mappingException(this._collectionType.getRawClass());
        }
        JsonDeserializer<String> valueDes = this._valueDeserializer;
        JsonToken t = jp.getCurrentToken();
        String value = t == JsonToken.VALUE_NULL ? null : (valueDes == null ? jp.getText() : valueDes.deserialize(jp, ctxt));
        result.add(value);
        return result;
    }
}

