/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.mr;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.elasticsearch.hadoop.mr.LinkedMapWritable;
import org.elasticsearch.hadoop.mr.WritableArrayWritable;
import org.elasticsearch.hadoop.mr.WritableCompatUtil;
import org.elasticsearch.hadoop.serialization.FieldType;
import org.elasticsearch.hadoop.serialization.builder.JdkValueReader;

public class WritableValueReader
extends JdkValueReader {
    @Override
    public Map createMap() {
        return new LinkedMapWritable();
    }

    @Override
    public Object createArray(FieldType type) {
        Class arrayType = null;
        switch (type) {
            case NULL: {
                arrayType = NullWritable.class;
                break;
            }
            case STRING: 
            case KEYWORD: 
            case TEXT: {
                arrayType = Text.class;
                break;
            }
            case BYTE: {
                arrayType = this.byteType();
                break;
            }
            case SHORT: {
                arrayType = this.shortType();
                break;
            }
            case INTEGER: {
                arrayType = IntWritable.class;
                break;
            }
            case TOKEN_COUNT: 
            case LONG: {
                arrayType = LongWritable.class;
                break;
            }
            case HALF_FLOAT: 
            case SCALED_FLOAT: 
            case FLOAT: {
                arrayType = FloatWritable.class;
                break;
            }
            case DOUBLE: {
                arrayType = this.doubleType();
                break;
            }
            case BOOLEAN: {
                arrayType = BooleanWritable.class;
                break;
            }
            case DATE: 
            case DATE_NANOS: {
                arrayType = this.dateType();
                break;
            }
            case BINARY: {
                arrayType = BytesWritable.class;
                break;
            }
            case OBJECT: 
            case NESTED: {
                arrayType = LinkedMapWritable.class;
                break;
            }
            default: {
                arrayType = Text.class;
            }
        }
        return new WritableArrayWritable(arrayType);
    }

    @Override
    public Object addToArray(Object array, List<Object> value) {
        ((ArrayWritable)array).set(value.toArray(new Writable[value.size()]));
        return array;
    }

    @Override
    protected int arrayDepth(Object potentialArray) {
        int depth = 0;
        while (potentialArray instanceof ArrayWritable) {
            ++depth;
            Writable[] array = ((ArrayWritable)potentialArray).get();
            if (array.length <= 0) continue;
            potentialArray = array[0];
        }
        return depth;
    }

    @Override
    protected Object wrapArray(Object array, int extraDepth) {
        Writable wrapper = (Writable)array;
        for (int i = 0; i < extraDepth; ++i) {
            wrapper = new ArrayWritable(ArrayWritable.class, new Writable[]{wrapper});
        }
        return wrapper;
    }

    protected Class<? extends Writable> dateType() {
        return Text.class;
    }

    protected Class<? extends Writable> doubleType() {
        return DoubleWritable.class;
    }

    protected Class<? extends Writable> byteType() {
        return ByteWritable.class;
    }

    protected Class<? extends Writable> shortType() {
        return WritableCompatUtil.availableShortType();
    }

    @Override
    protected Object binaryValue(byte[] value) {
        return new BytesWritable(value);
    }

    @Override
    protected Object processBoolean(Boolean value) {
        return new BooleanWritable(value.booleanValue());
    }

    @Override
    protected Object parseDate(Long value, boolean richDate) {
        return this.processLong(value);
    }

    @Override
    protected Object parseDate(String value, boolean richDate) {
        return this.parseString(value);
    }

    @Override
    protected Object processDouble(Double value) {
        return new DoubleWritable(value.doubleValue());
    }

    @Override
    protected Object processFloat(Float value) {
        return new FloatWritable(value.floatValue());
    }

    @Override
    protected Object processLong(Long value) {
        return new LongWritable(value.longValue());
    }

    @Override
    protected Object processInteger(Integer value) {
        return new IntWritable(value.intValue());
    }

    @Override
    protected Object processByte(Byte value) {
        return new ByteWritable(value.byteValue());
    }

    @Override
    protected Object processShort(Short value) {
        return WritableCompatUtil.availableShortWritable(value);
    }

    @Override
    protected Object parseString(String value) {
        return new Text(value);
    }

    @Override
    protected Object nullValue() {
        return NullWritable.get();
    }
}

