/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir.graph.algorithms;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.logstash.config.ir.graph.Graph;
import org.logstash.config.ir.graph.Vertex;

public class TopologicalSort {
    public static List<Vertex> sortVertices(Graph g) throws UnexpectedGraphCycleError {
        if (g.getEdges().size() == 0) {
            return new ArrayList<Vertex>(g.getVertices());
        }
        ArrayList<Vertex> sorted = new ArrayList<Vertex>(g.getVertices().size());
        LinkedList<Vertex> pending = new LinkedList<Vertex>();
        pending.addAll(g.getRoots());
        HashSet traversedEdges = new HashSet();
        while (!pending.isEmpty()) {
            Vertex currentVertex = (Vertex)pending.removeFirst();
            sorted.add(currentVertex);
            currentVertex.getOutgoingEdges().forEach(edge -> {
                traversedEdges.add(edge);
                Vertex toVertex = edge.getTo();
                if (toVertex.getIncomingEdges().stream().allMatch(traversedEdges::contains)) {
                    pending.add(toVertex);
                }
            });
        }
        if (g.edges().noneMatch(traversedEdges::contains)) {
            throw new UnexpectedGraphCycleError(g);
        }
        return sorted;
    }

    public static class UnexpectedGraphCycleError
    extends Exception {
        private static final long serialVersionUID = 1778155790783320839L;

        UnexpectedGraphCycleError(Graph g) {
            super("Graph has cycles, is not a DAG! " + String.valueOf(g));
        }
    }
}

