/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.schedulers;

import rx.Scheduler;
import rx.exceptions.Exceptions;
import rx.functions.Action0;

class SleepingAction
implements Action0 {
    private final Action0 underlying;
    private final Scheduler.Worker innerScheduler;
    private final long execTime;

    public SleepingAction(Action0 underlying, Scheduler.Worker scheduler, long execTime) {
        this.underlying = underlying;
        this.innerScheduler = scheduler;
        this.execTime = execTime;
    }

    @Override
    public void call() {
        if (this.innerScheduler.isUnsubscribed()) {
            return;
        }
        long delay = this.execTime - this.innerScheduler.now();
        if (delay > 0L) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Exceptions.propagate(e);
            }
        }
        if (this.innerScheduler.isUnsubscribed()) {
            return;
        }
        this.underlying.call();
    }
}

