/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.locks;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.Limit;
import org.apache.derby.iapi.services.locks.LockOwner;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.iapi.util.Matchable;
import org.apache.derby.impl.services.locks.Lock;
import org.apache.derby.impl.services.locks.LockList;
import org.apache.derby.impl.services.locks.LockTable;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

final class LockSpace
implements CompatibilitySpace {
    private final HashMap<Object, HashMap<Lock, Lock>> groups;
    private final LockOwner owner;
    private static final int MAX_CACHED_GROUPS = 3;
    private final ArrayDeque<HashMap<Lock, Lock>> spareGroups = new ArrayDeque(3);
    private Object callbackGroup;
    private int limit;
    private int nextLimitCall;
    private Limit callback;
    private boolean inLimit;

    LockSpace(LockOwner owner) {
        this.groups = new HashMap();
        this.owner = owner;
    }

    @Override
    public LockOwner getOwner() {
        return this.owner;
    }

    protected synchronized void addLock(Object group, Lock lock) throws StandardException {
        Lock lockInGroup = null;
        HashMap<Lock, Lock> dl = this.groups.get(group);
        if (dl == null) {
            dl = this.getGroupMap(group);
        } else if (lock.getCount() != 1) {
            lockInGroup = dl.get(lock);
        }
        if (lockInGroup == null) {
            lockInGroup = lock.copy();
            dl.put(lockInGroup, lockInGroup);
        }
        ++lockInGroup.count;
        if (this.inLimit) {
            return;
        }
        if (!group.equals(this.callbackGroup)) {
            return;
        }
        int groupSize = dl.size();
        if (groupSize > this.nextLimitCall) {
            this.inLimit = true;
            this.callback.reached(this, group, this.limit, new LockList(Collections.enumeration(dl.keySet())), groupSize);
            this.inLimit = false;
            int newGroupSize = dl.size();
            this.nextLimitCall = newGroupSize < this.limit / 2 ? this.limit : (newGroupSize < this.nextLimitCall / 2 ? (this.nextLimitCall -= this.limit) : (this.nextLimitCall += this.limit));
        }
    }

    synchronized void unlockGroup(LockTable lset, Object group) {
        HashMap<Lock, Lock> dl = this.groups.remove(group);
        if (dl == null) {
            return;
        }
        for (Lock lock : dl.keySet()) {
            lset.unlock(lock, 0);
        }
        if (this.callbackGroup != null && group.equals(this.callbackGroup)) {
            this.nextLimitCall = this.limit;
        }
        this.saveGroup(dl);
    }

    private HashMap<Lock, Lock> getGroupMap(Object group) {
        HashMap<Lock, Lock> dl = this.spareGroups.poll();
        if (dl == null) {
            dl = new HashMap(5, 0.8f);
        }
        this.groups.put(group, dl);
        return dl;
    }

    private void saveGroup(HashMap<Lock, Lock> dl) {
        if (this.spareGroups.size() < 3) {
            this.spareGroups.offer(dl);
            dl.clear();
        }
    }

    synchronized void unlockGroup(LockTable lset, Object group, Matchable key) {
        HashMap<Lock, Lock> dl = this.groups.get(group);
        if (dl == null) {
            return;
        }
        boolean allUnlocked = true;
        Iterator<Lock> e = dl.keySet().iterator();
        while (e.hasNext()) {
            Lock lock = e.next();
            if (!key.match(lock.getLockable())) {
                allUnlocked = false;
                continue;
            }
            lset.unlock(lock, 0);
            e.remove();
        }
        if (allUnlocked) {
            this.groups.remove(group);
            this.saveGroup(dl);
            if (this.callbackGroup != null && group.equals(this.callbackGroup)) {
                this.nextLimitCall = this.limit;
            }
        }
    }

    synchronized void transfer(Object oldGroup, Object newGroup) {
        HashMap<Lock, Lock> from = this.groups.get(oldGroup);
        if (from == null) {
            return;
        }
        HashMap<Lock, Lock> to = this.groups.get(newGroup);
        if (to == null) {
            this.groups.put(newGroup, from);
            this.clearLimit(oldGroup);
            this.groups.remove(oldGroup);
            return;
        }
        if (to.size() < from.size()) {
            this.mergeGroups(to, from);
            HashMap<Lock, Lock> oldTo = this.groups.put(newGroup, from);
            SanityManager.ASSERT((oldTo == to ? 1 : 0) != 0, (String)"inconsistent state in LockSpace");
        } else {
            this.mergeGroups(from, to);
        }
        this.clearLimit(oldGroup);
        this.groups.remove(oldGroup);
    }

    private void mergeGroups(HashMap<Lock, Lock> from, HashMap<Lock, Lock> into) {
        for (Lock lock : from.keySet()) {
            Lock lockI = into.get(lock);
            if (lockI == null) {
                into.put(lock, lock);
                continue;
            }
            Lock fromL = lock;
            Lock intoL = lockI;
            intoL.count += fromL.getCount();
        }
    }

    synchronized int unlockReference(LockTable lset, Lockable ref, Object qualifier, Object group) {
        HashMap<Lock, Lock> dl = this.groups.get(group);
        if (dl == null) {
            return 0;
        }
        Lock lockInGroup = lset.unlockReference(this, ref, qualifier, dl);
        if (lockInGroup == null) {
            return 0;
        }
        if (lockInGroup.getCount() == 1) {
            if (dl.isEmpty()) {
                this.groups.remove(group);
                this.saveGroup(dl);
                if (this.callbackGroup != null && group.equals(this.callbackGroup)) {
                    this.nextLimitCall = this.limit;
                }
            }
            return 1;
        }
        --lockInGroup.count;
        dl.put(lockInGroup, lockInGroup);
        return 1;
    }

    synchronized boolean areLocksHeld(Object group) {
        return this.groups.containsKey(group);
    }

    synchronized boolean areLocksHeld() {
        return !this.groups.isEmpty();
    }

    synchronized boolean isLockHeld(Object group, Lockable ref, Object qualifier) {
        HashMap<Lock, Lock> dl = this.groups.get(group);
        if (dl == null) {
            return false;
        }
        return dl.containsKey(new Lock(this, ref, qualifier));
    }

    synchronized void setLimit(Object group, int limit, Limit callback) {
        this.callbackGroup = group;
        this.nextLimitCall = this.limit = limit;
        this.callback = callback;
    }

    synchronized void clearLimit(Object group) {
        if (group.equals(this.callbackGroup)) {
            this.callbackGroup = null;
            this.limit = Integer.MAX_VALUE;
            this.nextLimitCall = Integer.MAX_VALUE;
            this.callback = null;
        }
    }

    synchronized int deadlockCount(int bail) {
        int count = 0;
        for (HashMap<Lock, Lock> group : this.groups.values()) {
            for (Lock lock : group.keySet()) {
                if ((count += lock.getCount()) <= bail) continue;
                return count;
            }
        }
        return count;
    }
}

