/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.expr.parser.ExpressionLocation;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.SchemaURIResolver;
import net.sf.saxon.lib.UnfailingErrorListener;
import net.sf.saxon.om.Item;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PipelineConfiguration {
    private Configuration config;
    private LocationProvider locationProvider;
    private URIResolver uriResolver;
    private SchemaURIResolver schemaURIResolver;
    private Controller controller;
    private Stack<Item> currentApplyStack;
    private ParseOptions parseOptions;
    private boolean isSerializing;
    private int hostLanguage = 50;
    private Map<String, Object> components;

    public PipelineConfiguration(Configuration config) {
        this.config = config;
        this.parseOptions = new ParseOptions();
    }

    public PipelineConfiguration(PipelineConfiguration p) {
        this.config = p.config;
        this.locationProvider = p.locationProvider;
        this.uriResolver = p.uriResolver;
        this.schemaURIResolver = p.schemaURIResolver;
        this.controller = p.controller;
        this.isSerializing = p.isSerializing;
        this.parseOptions = new ParseOptions(p.parseOptions);
        this.hostLanguage = p.hostLanguage;
        if (p.components != null) {
            this.components = new HashMap<String, Object>(p.components);
        }
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public LocationProvider getLocationProvider() {
        if (this.locationProvider == null) {
            this.locationProvider = DummyLocationProvider.THE_INSTANCE;
        }
        return this.locationProvider;
    }

    public void setLocationProvider(LocationProvider locationProvider) {
        this.locationProvider = locationProvider;
    }

    public SourceLocator getSourceLocation(int locationId) {
        return new ExpressionLocation(this.locationProvider, locationId);
    }

    public UnfailingErrorListener getLocalErrorListener() {
        return this.parseOptions.getErrorListener();
    }

    public UnfailingErrorListener getErrorListener() {
        UnfailingErrorListener listener = this.parseOptions.getErrorListener();
        if (listener == null) {
            listener = this.config.getErrorListener();
        }
        return listener;
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.parseOptions.setErrorListener(errorListener);
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public void setURIResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public SchemaURIResolver getSchemaURIResolver() {
        return this.schemaURIResolver;
    }

    public void setParseOptions(ParseOptions options) {
        this.parseOptions = options;
    }

    public ParseOptions getParseOptions() {
        return this.parseOptions;
    }

    public void setUseXsiSchemaLocation(boolean recognize) {
        this.parseOptions.setUseXsiSchemaLocation(recognize);
    }

    public void setRecoverFromValidationErrors(boolean recover) {
        this.parseOptions.setContinueAfterValidationErrors(recover);
    }

    public boolean isRecoverFromValidationErrors() {
        return this.parseOptions.isContinueAfterValidationErrors();
    }

    public void setSchemaURIResolver(SchemaURIResolver resolver) {
        this.schemaURIResolver = resolver;
    }

    public Controller getController() {
        return this.controller;
    }

    public void pushCurrentAppliedItem(Item item) {
        if (this.currentApplyStack == null) {
            this.currentApplyStack = new Stack();
        }
        this.currentApplyStack.push(item);
    }

    public void popCurrentAppliedItem() {
        this.currentApplyStack.pop();
    }

    public Item peekCurrentAppliedItem() {
        if (this.currentApplyStack != null && this.currentApplyStack.size() > 0) {
            return this.currentApplyStack.peek();
        }
        return null;
    }

    public Stack<Item> getAppliedItemStack() {
        return this.currentApplyStack;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public int getHostLanguage() {
        return this.hostLanguage;
    }

    public void setHostLanguage(int language) {
        this.hostLanguage = language;
    }

    public boolean isSerializing() {
        return this.isSerializing;
    }

    public void setSerializing(boolean isSerializing) {
        this.isSerializing = isSerializing;
    }

    public void setExpandAttributeDefaults(boolean expand) {
        this.parseOptions.setExpandAttributeDefaults(expand);
    }

    public void setComponent(String name, Object value) {
        if (this.components == null) {
            this.components = new HashMap<String, Object>();
        }
        this.components.put(name, value);
    }

    public Object getComponent(String name) {
        if (this.components == null) {
            return null;
        }
        return this.components.get(name);
    }

    private static class DummyLocationProvider
    implements LocationProvider {
        public static final DummyLocationProvider THE_INSTANCE = new DummyLocationProvider();

        private DummyLocationProvider() {
        }

        public String getSystemId(int locationId) {
            return null;
        }

        public int getLineNumber(int locationId) {
            return -1;
        }

        public int getColumnNumber(int locationId) {
            return -1;
        }
    }
}

