/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.common;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class BufferedTokenizer {
    private final DataSplitter dataSplitter;
    private final Iterable<String> iterable;

    public BufferedTokenizer() {
        this("\n");
    }

    public BufferedTokenizer(String separator) {
        this.dataSplitter = new DataSplitter(separator);
        this.iterable = () -> this.dataSplitter;
    }

    public BufferedTokenizer(String separator, int sizeLimit) {
        if (sizeLimit <= 0) {
            throw new IllegalArgumentException("Size limit must be positive");
        }
        this.dataSplitter = new DataSplitter(separator, sizeLimit);
        this.iterable = () -> this.dataSplitter;
    }

    public Iterable<String> extract(String data) {
        this.dataSplitter.append(data);
        return this.iterable;
    }

    public String flush() {
        return this.dataSplitter.flush();
    }

    public String toString() {
        return this.dataSplitter.toString();
    }

    public boolean isEmpty() {
        return this.dataSplitter.isBufferEmpty();
    }

    static class DataSplitter
    implements Iterator<String> {
        private final String separator;
        private int currentIdx = 0;
        private int nextSeparatorIdx = -1;
        private final StringBuilder accumulator = new StringBuilder();
        private final int sizeLimit;
        private int lastFragmentSize = 0;

        DataSplitter(String separator) {
            this.separator = separator;
            this.sizeLimit = Integer.MIN_VALUE;
        }

        DataSplitter(String separator, int sizeLimit) {
            this.separator = separator;
            this.sizeLimit = sizeLimit;
        }

        @Override
        public synchronized boolean hasNext() {
            return this.matchNextSeparatorIdx();
        }

        @Override
        public synchronized String next() {
            if (!this.matchNextSeparatorIdx()) {
                throw new NoSuchElementException();
            }
            String token = this.accumulator.substring(this.currentIdx, this.nextSeparatorIdx);
            this.currentIdx = this.nextSeparatorIdx + this.separator.length();
            if (this.isSizeLimitSet() && token.length() > this.sizeLimit) {
                throw new IllegalStateException("input buffer full, consumed token which exceeded the sizeLimit " + this.sizeLimit);
            }
            this.nextSeparatorIdx = -1;
            return token;
        }

        private boolean matchNextSeparatorIdx() {
            this.nextSeparatorIdx = this.accumulator.indexOf(this.separator, this.currentIdx);
            if (this.nextSeparatorIdx == -1 && this.currentIdx > 0) {
                this.cleanupAccumulator();
            }
            return this.nextSeparatorIdx != -1;
        }

        private void cleanupAccumulator() {
            this.accumulator.delete(0, this.currentIdx);
            this.currentIdx = 0;
        }

        public void append(String data) {
            if (this.isSizeLimitSet()) {
                if (!data.contains(this.separator) && this.lastFragmentSize > this.sizeLimit) {
                    return;
                }
                int lastSeparatorIdx = data.lastIndexOf(this.separator);
                this.lastFragmentSize = lastSeparatorIdx == -1 ? (this.lastFragmentSize += data.length()) : data.length() - (lastSeparatorIdx + this.separator.length());
            }
            this.accumulator.append(data);
        }

        private boolean isSizeLimitSet() {
            return this.sizeLimit != Integer.MIN_VALUE;
        }

        public String flush() {
            String flushed = this.accumulator.substring(this.currentIdx);
            this.accumulator.setLength(0);
            this.currentIdx = 0;
            return flushed;
        }

        public synchronized boolean isBufferEmpty() {
            return this.currentIdx >= this.accumulator.length();
        }

        public synchronized String toString() {
            return "accumulator=" + String.valueOf(this.accumulator) + ", currentIdx=" + this.currentIdx;
        }
    }

    static abstract class IteratorDecorator<T>
    implements Iterator<T> {
        protected final Iterator<String> iterator;

        IteratorDecorator(Iterator<String> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }
    }
}

