/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.shared.common.security;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;

public final class SystemPermission
extends BasicPermission {
    private static final long serialVersionUID = 1965420504091489898L;
    public static final String SERVER = "server";
    public static final String ENGINE = "engine";
    public static final String JMX = "jmx";
    public static final String SHUTDOWN = "shutdown";
    public static final String CONTROL = "control";
    public static final String MONITOR = "monitor";
    public static final String USE_DERBY_INTERNALS = "usederbyinternals";
    private static final Set<String> LEGAL_NAMES = new HashSet<String>();
    private static final List<String> LEGAL_ACTIONS;
    public static final SystemPermission ENGINE_MONITOR;
    private String actions;
    private transient int actionMask;

    public SystemPermission(String name, String actions) {
        super(name);
        this.validateNameAndActions(name, actions);
    }

    private void validateNameAndActions(String name, String actions) {
        if (!LEGAL_NAMES.contains(name)) {
            throw new IllegalArgumentException("Unknown permission " + name);
        }
        this.actions = SystemPermission.getCanonicalForm(actions);
        this.actionMask = SystemPermission.getActionMask(this.actions);
    }

    @Override
    public String getActions() {
        return this.actions;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new SystemPermissionCollection();
    }

    private static String getCanonicalForm(String actions) {
        Set<String> actionSet = SystemPermission.parseActions(actions);
        ArrayList<String> legalActions = new ArrayList<String>(LEGAL_ACTIONS);
        legalActions.retainAll(actionSet);
        return SystemPermission.buildActionsString(legalActions);
    }

    public static Set<String> parseActions(String actions) {
        HashSet<String> actionSet = new HashSet<String>();
        for (String s : actions.split(",", -1)) {
            actionSet.add(s.trim().toLowerCase(Locale.ENGLISH));
        }
        return actionSet;
    }

    public static String buildActionsString(Iterable<String> actions) {
        StringBuilder sb = new StringBuilder();
        for (String action : actions) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(action);
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        SystemPermission osp = (SystemPermission)other;
        return this.actionMask == osp.actionMask;
    }

    @Override
    public boolean implies(Permission permission) {
        if (!super.implies(permission)) {
            return false;
        }
        int myActionMask = this.actionMask;
        int permissionMask = ((SystemPermission)permission).actionMask;
        return (myActionMask & permissionMask) == permissionMask;
    }

    private static int getActionMask(String actions) {
        int mask = 0;
        StringTokenizer st = new StringTokenizer(actions, ",");
        while (st.hasMoreTokens()) {
            int validAction = LEGAL_ACTIONS.indexOf(st.nextElement());
            if (validAction == -1) continue;
            mask |= 1 << validAction;
        }
        return mask;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.validateNameAndActions(this.getName(), this.getActions());
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "( " + this.doubleQuote(this.getName()) + ", " + this.doubleQuote(this.actions) + " )";
    }

    private String doubleQuote(String raw) {
        return "\"" + raw + "\"";
    }

    static {
        LEGAL_NAMES.add(SERVER);
        LEGAL_NAMES.add(ENGINE);
        LEGAL_NAMES.add(JMX);
        LEGAL_ACTIONS = new ArrayList<String>();
        LEGAL_ACTIONS.add(CONTROL);
        LEGAL_ACTIONS.add(MONITOR);
        LEGAL_ACTIONS.add(SHUTDOWN);
        LEGAL_ACTIONS.add(USE_DERBY_INTERNALS);
        ENGINE_MONITOR = new SystemPermission(ENGINE, MONITOR);
    }

    private static class SystemPermissionCollection
    extends PermissionCollection {
        private static final long serialVersionUID = 0L;
        private HashMap<String, Permission> permissions = new HashMap();

        private SystemPermissionCollection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(Permission permission) {
            if (!(permission instanceof SystemPermission)) {
                throw new IllegalArgumentException();
            }
            if (this.isReadOnly()) {
                throw new SecurityException();
            }
            String name = permission.getName();
            SystemPermissionCollection systemPermissionCollection = this;
            synchronized (systemPermissionCollection) {
                Permission existing = this.permissions.get(name);
                if (existing == null) {
                    this.permissions.put(name, permission);
                } else {
                    String actions = existing.getActions() + "," + permission.getActions();
                    this.permissions.put(name, new SystemPermission(name, actions));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean implies(Permission permission) {
            Permission perm;
            if (!(permission instanceof SystemPermission)) {
                return false;
            }
            String name = permission.getName();
            SystemPermissionCollection systemPermissionCollection = this;
            synchronized (systemPermissionCollection) {
                perm = this.permissions.get(name);
            }
            return perm != null && perm.implies(permission);
        }

        @Override
        public synchronized Enumeration<Permission> elements() {
            return Collections.enumeration(this.permissions.values());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream s) throws IOException {
            ArrayList<Permission> perms;
            SystemPermissionCollection systemPermissionCollection = this;
            synchronized (systemPermissionCollection) {
                perms = new ArrayList<Permission>(this.permissions.values());
            }
            ObjectOutputStream.PutField fields = s.putFields();
            fields.put("permissions", perms);
            s.writeFields();
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            ObjectInputStream.GetField fields = s.readFields();
            List perms = (List)fields.get("permissions", null);
            this.permissions = new HashMap();
            for (Object p : perms) {
                SystemPermission sp = (SystemPermission)p;
                this.permissions.put(sp.getName(), sp);
            }
        }
    }
}

