/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.mapper;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import org.apache.lucene.document.LatLonShape;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.common.geo.GeoFormatterFactory;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeometryParser;
import org.elasticsearch.common.geo.Orientation;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.utils.GeometryValidator;
import org.elasticsearch.geometry.utils.WellKnownBinary;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.elasticsearch.index.mapper.AbstractShapeGeometryFieldMapper;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.GeoShapeIndexer;
import org.elasticsearch.index.mapper.GeoShapeParser;
import org.elasticsearch.index.mapper.GeoShapeQueryable;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.OnScriptError;
import org.elasticsearch.index.mapper.StoredValueFetcher;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.legacygeo.mapper.LegacyGeoShapeFieldMapper;
import org.elasticsearch.lucene.spatial.BinaryShapeDocValuesField;
import org.elasticsearch.lucene.spatial.CoordinateEncoder;
import org.elasticsearch.lucene.spatial.LatLonShapeDocValuesQuery;
import org.elasticsearch.script.GeometryFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.script.field.AbstractScriptFieldFactory;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.script.field.Field;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.FieldValues;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoShapeValues;
import org.elasticsearch.xpack.spatial.index.fielddata.plain.AbstractAtomicGeoShapeShapeFieldData;
import org.elasticsearch.xpack.spatial.index.fielddata.plain.LatLonShapeIndexFieldData;
import org.elasticsearch.xpack.spatial.search.aggregations.support.GeoShapeValuesSourceType;

public class GeoShapeWithDocValuesFieldMapper
extends AbstractShapeGeometryFieldMapper<Geometry> {
    public static final String CONTENT_TYPE = "geo_shape";
    private final Builder builder;
    private final GeoShapeIndexer indexer;

    private static Builder builder(FieldMapper in) {
        return ((GeoShapeWithDocValuesFieldMapper)in).builder;
    }

    public GeoShapeWithDocValuesFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.BuilderParams builderParams, GeoShapeIndexer indexer, GeoShapeParser parser, Builder builder) {
        super(simpleName, mappedFieldType, builderParams, builder.ignoreMalformed.get(), builder.coerce.get(), builder.ignoreZValue.get(), builder.orientation.get(), parser);
        this.builder = builder;
        this.indexer = indexer;
    }

    @Override
    protected void index(DocumentParserContext context, Geometry geometry) {
        if (geometry == null) {
            return;
        }
        Geometry normalizedGeometry = this.indexer.normalize(geometry);
        List<IndexableField> fields = this.indexer.getIndexableFields(normalizedGeometry);
        if (this.fieldType().isIndexed()) {
            context.doc().addAll(fields);
        }
        if (this.fieldType().hasDocValues()) {
            String name = this.fieldType().name();
            BinaryShapeDocValuesField docValuesField = (BinaryShapeDocValuesField)context.doc().getByKey(name);
            if (docValuesField == null) {
                docValuesField = new BinaryShapeDocValuesField(name, CoordinateEncoder.GEO);
                context.doc().addWithKey(name, docValuesField);
            }
            docValuesField.add(fields, geometry);
        } else if (this.fieldType().isIndexed()) {
            context.addToFieldNames(this.fieldType().name());
        }
        if (this.fieldType().isStored()) {
            context.doc().add(new StoredField(this.fieldType().name(), WellKnownBinary.toWKB(normalizedGeometry, ByteOrder.LITTLE_ENDIAN)));
        }
    }

    @Override
    protected void indexScriptValues(SearchLookup searchLookup, LeafReaderContext readerContext, int doc, DocumentParserContext documentParserContext) {
        this.fieldType().scriptValues.valuesForDoc(searchLookup, readerContext, doc, geometry -> this.index(documentParserContext, (Geometry)geometry));
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.builder.version, this.builder.scriptCompiler, this.builder.ignoreMalformed.getDefaultValue().value(), this.builder.coerce.getDefaultValue().value(), this.builder.geoFormatterFactory).init(this);
    }

    @Override
    public GeoShapeWithDocValuesFieldType fieldType() {
        return (GeoShapeWithDocValuesFieldType)super.fieldType();
    }

    @Override
    protected void checkIncomingMergeType(FieldMapper mergeWith) {
        if (!(mergeWith instanceof GeoShapeWithDocValuesFieldMapper) && CONTENT_TYPE.equals(mergeWith.typeName())) {
            throw new IllegalArgumentException("mapper [" + this.fullPath() + "] of type [geo_shape] cannot change strategy from [BKD] to [recursive]");
        }
        super.checkIncomingMergeType(mergeWith);
    }

    public static final class Builder
    extends FieldMapper.Builder {
        final FieldMapper.Parameter<Boolean> indexed = FieldMapper.Parameter.indexParam(m -> GeoShapeWithDocValuesFieldMapper.builder((FieldMapper)m).indexed.get(), true);
        final FieldMapper.Parameter<Boolean> stored = FieldMapper.Parameter.storeParam(m -> GeoShapeWithDocValuesFieldMapper.builder((FieldMapper)m).stored.get(), false);
        final FieldMapper.Parameter<Boolean> hasDocValues;
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreMalformed;
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreZValue = AbstractGeometryFieldMapper.ignoreZValueParam(m -> GeoShapeWithDocValuesFieldMapper.builder((FieldMapper)m).ignoreZValue.get());
        final FieldMapper.Parameter<Explicit<Boolean>> coerce;
        final FieldMapper.Parameter<Explicit<Orientation>> orientation = AbstractShapeGeometryFieldMapper.orientationParam(m -> GeoShapeWithDocValuesFieldMapper.builder((FieldMapper)m).orientation.get());
        private final FieldMapper.Parameter<Script> script = FieldMapper.Parameter.scriptParam(m -> GeoShapeWithDocValuesFieldMapper.builder((FieldMapper)m).script.get());
        private final FieldMapper.Parameter<OnScriptError> onScriptErrorParam = FieldMapper.Parameter.onScriptErrorParam(m -> GeoShapeWithDocValuesFieldMapper.builder((FieldMapper)m).onScriptError, this.script);
        final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final ScriptCompiler scriptCompiler;
        private final IndexVersion version;
        private final GeoFormatterFactory<Geometry> geoFormatterFactory;

        public Builder(String name, IndexVersion version, ScriptCompiler scriptCompiler, boolean ignoreMalformedByDefault, boolean coerceByDefault, GeoFormatterFactory<Geometry> geoFormatterFactory) {
            super(name);
            this.version = version;
            this.scriptCompiler = scriptCompiler;
            this.geoFormatterFactory = geoFormatterFactory;
            this.ignoreMalformed = AbstractGeometryFieldMapper.ignoreMalformedParam(m -> GeoShapeWithDocValuesFieldMapper.builder((FieldMapper)m).ignoreMalformed.get(), ignoreMalformedByDefault);
            this.coerce = AbstractShapeGeometryFieldMapper.coerceParam(m -> GeoShapeWithDocValuesFieldMapper.builder((FieldMapper)m).coerce.get(), coerceByDefault);
            this.hasDocValues = FieldMapper.Parameter.docValuesParam(m -> GeoShapeWithDocValuesFieldMapper.builder((FieldMapper)m).hasDocValues.get(), IndexVersions.V_7_8_0.onOrBefore(version));
            this.addScriptValidation(this.script, this.indexed, this.hasDocValues);
        }

        Builder setStored(boolean stored) {
            this.stored.setValue(stored);
            return this;
        }

        @Override
        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.indexed, this.hasDocValues, this.stored, this.ignoreMalformed, this.ignoreZValue, this.coerce, this.orientation, this.script, this.onScriptErrorParam, this.meta};
        }

        private FieldValues<Geometry> scriptValues() {
            if (this.script.get() == null) {
                return null;
            }
            GeometryFieldScript.Factory factory = this.scriptCompiler.compile(this.script.get(), GeometryFieldScript.CONTEXT);
            return factory == null ? null : (lookup, ctx, doc, consumer) -> factory.newFactory(this.leafName(), this.script.get().getParams(), lookup, OnScriptError.FAIL).newInstance(ctx).runForDoc(doc, consumer);
        }

        @Override
        public GeoShapeWithDocValuesFieldMapper build(MapperBuilderContext context) {
            if (this.multiFieldsBuilder.hasMultiFields()) {
                DEPRECATION_LOGGER.warn(DeprecationCategory.MAPPINGS, "geo_shape_multifields", "Adding multifields to [geo_shape] mappers has no effect", new Object[0]);
            }
            GeometryParser geometryParser = new GeometryParser(this.orientation.get().value().getAsBoolean(), this.coerce.get().value(), this.ignoreZValue.get().value());
            GeoShapeParser parser = new GeoShapeParser(geometryParser, this.orientation.get().value());
            GeoShapeWithDocValuesFieldType ft = new GeoShapeWithDocValuesFieldType(context.buildFullName(this.leafName()), this.indexed.get(), this.hasDocValues.get(), this.stored.get(), this.orientation.get().value(), parser, this.scriptValues(), this.geoFormatterFactory, context.isSourceSynthetic(), this.meta.get());
            this.hasScript = this.script.get() != null;
            this.onScriptError = this.onScriptErrorParam.get();
            return new GeoShapeWithDocValuesFieldMapper(this.leafName(), (MappedFieldType)ft, this.builderParams(this, context), new GeoShapeIndexer(this.orientation.get().value(), ft.name()), parser, this);
        }
    }

    public static final class GeoShapeWithDocValuesFieldType
    extends AbstractShapeGeometryFieldMapper.AbstractShapeGeometryFieldType<Geometry>
    implements GeoShapeQueryable {
        private final GeoFormatterFactory<Geometry> geoFormatterFactory;
        private final FieldValues<Geometry> scriptValues;
        private final boolean isSyntheticSource;

        public GeoShapeWithDocValuesFieldType(String name, boolean indexed, boolean hasDocValues, boolean isStored, Orientation orientation, GeoShapeParser parser, FieldValues<Geometry> scriptValues, GeoFormatterFactory<Geometry> geoFormatterFactory, boolean isSyntheticSource, Map<String, String> meta) {
            super(name, indexed, isStored, hasDocValues, parser, orientation, meta);
            this.scriptValues = scriptValues;
            this.geoFormatterFactory = geoFormatterFactory;
            this.isSyntheticSource = isSyntheticSource;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            this.failIfNoDocValues();
            return (cache, breakerService) -> new LatLonShapeIndexFieldData(this.name(), (ValuesSourceType)GeoShapeValuesSourceType.instance(), GeoShapeDocValuesField::new);
        }

        @Override
        public String typeName() {
            return GeoShapeWithDocValuesFieldMapper.CONTENT_TYPE;
        }

        @Override
        public Query geoShapeQuery(SearchExecutionContext context, String fieldName, ShapeRelation relation, LatLonGeometry ... geometries) {
            Query query;
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (relation == ShapeRelation.CONTAINS && context.indexVersionCreated().before(IndexVersions.V_7_5_0)) {
                throw new QueryShardException((QueryRewriteContext)context, String.valueOf(ShapeRelation.CONTAINS) + " query relation not supported for Field [" + fieldName + "].", new Object[0]);
            }
            if (this.isIndexed()) {
                query = LatLonShape.newGeometryQuery(fieldName, relation.getLuceneRelation(), geometries);
                if (this.hasDocValues()) {
                    LatLonShapeDocValuesQuery queryDocValues = new LatLonShapeDocValuesQuery(fieldName, relation.getLuceneRelation(), geometries);
                    query = new IndexOrDocValuesQuery(query, queryDocValues);
                }
            } else {
                query = new LatLonShapeDocValuesQuery(fieldName, relation.getLuceneRelation(), geometries);
            }
            return query;
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (this.isStored()) {
                final Function<List<Geometry>, List<Object>> formatter = this.getFormatter(format != null ? format : "geojson");
                return new StoredValueFetcher(context.lookup(), this.name()){

                    @Override
                    public List<Object> parseStoredValues(List<Object> storedValues) {
                        ArrayList<Geometry> values = new ArrayList<Geometry>(storedValues.size());
                        for (Object storedValue : storedValues) {
                            if (storedValue instanceof BytesRef) {
                                BytesRef bytesRef = (BytesRef)storedValue;
                                values.add(WellKnownBinary.fromWKB(GeometryValidator.NOOP, false, bytesRef.bytes, bytesRef.offset, bytesRef.length));
                                continue;
                            }
                            throw new IllegalArgumentException("Unexpected class fetching [" + this.name() + "]: " + String.valueOf(storedValue.getClass()));
                        }
                        return (List)formatter.apply(values);
                    }
                };
            }
            if (this.scriptValues != null) {
                Function formatter = this.getFormatter(format != null ? format : "geojson");
                return FieldValues.valueListFetcher(this.scriptValues, formatter, context);
            }
            return super.valueFetcher(context, format);
        }

        @Override
        protected Function<List<Geometry>, List<Object>> getFormatter(String format) {
            return this.geoFormatterFactory.getFormatter(format, Function.identity());
        }

        @Override
        public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
            if (blContext.fieldExtractPreference() == MappedFieldType.FieldExtractPreference.EXTRACT_SPATIAL_BOUNDS) {
                return new GeoBoundsBlockLoader(this.name());
            }
            if (this.isSyntheticSource && blContext.parentField(this.name()) == null) {
                return this.blockLoaderFromFallbackSyntheticSource(blContext);
            }
            return this.blockLoaderFromSource(blContext);
        }

        static class GeoBoundsBlockLoader
        extends AbstractShapeGeometryFieldMapper.AbstractShapeGeometryFieldType.BoundsBlockLoader {
            GeoBoundsBlockLoader(String fieldName) {
                super(fieldName);
            }
        }
    }

    public static class GeoShapeDocValuesField
    extends AbstractScriptFieldFactory<GeoShapeValues.GeoShapeValue>
    implements Field<GeoShapeValues.GeoShapeValue>,
    DocValuesScriptFieldFactory,
    ScriptDocValues.GeometrySupplier<GeoPoint, GeoShapeValues.GeoShapeValue> {
        private final GeoShapeValues in;
        protected final String name;
        private GeoShapeValues.GeoShapeValue value;
        private final GeoPoint centroid = new GeoPoint();
        private final GeoBoundingBox boundingBox = new GeoBoundingBox(new GeoPoint(), new GeoPoint());
        private ScriptDocValues<GeoShapeValues.GeoShapeValue> geoShapeScriptValues;

        public GeoShapeDocValuesField(GeoShapeValues in, String name) {
            this.in = in;
            this.name = name;
        }

        @Override
        public void setNextDocId(int docId) throws IOException {
            if (this.in.advanceExact(docId)) {
                this.value = (GeoShapeValues.GeoShapeValue)this.in.value();
                this.centroid.reset(this.value.getY(), this.value.getX());
                this.boundingBox.topLeft().reset(this.value.boundingBox().maxY(), this.value.boundingBox().minX());
                this.boundingBox.bottomRight().reset(this.value.boundingBox().minY(), this.value.boundingBox().maxX());
            } else {
                this.value = null;
            }
        }

        public ScriptDocValues<GeoShapeValues.GeoShapeValue> toScriptDocValues() {
            if (this.geoShapeScriptValues == null) {
                this.geoShapeScriptValues = new AbstractAtomicGeoShapeShapeFieldData.GeoShapeScriptValues(this);
            }
            return this.geoShapeScriptValues;
        }

        @Override
        public GeoShapeValues.GeoShapeValue getInternal(int index) {
            if (index != 0) {
                throw new UnsupportedOperationException();
            }
            return this.value;
        }

        @Override
        public GeoPoint getInternalCentroid() {
            return this.centroid;
        }

        public GeoBoundingBox getInternalBoundingBox() {
            return this.boundingBox;
        }

        @Override
        public GeoPoint getInternalLabelPosition() {
            try {
                return new GeoPoint(this.value.labelPosition());
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to parse geo shape label position: " + e.getMessage(), e);
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isEmpty() {
            return this.value == null;
        }

        @Override
        public int size() {
            return this.value == null ? 0 : 1;
        }

        public GeoShapeValues.GeoShapeValue get(GeoShapeValues.GeoShapeValue defaultValue) {
            return this.get(0, defaultValue);
        }

        public GeoShapeValues.GeoShapeValue get(int index, GeoShapeValues.GeoShapeValue defaultValue) {
            if (this.isEmpty() || index != 0) {
                return defaultValue;
            }
            return this.value;
        }

        @Override
        public Iterator<GeoShapeValues.GeoShapeValue> iterator() {
            return new Iterator<GeoShapeValues.GeoShapeValue>(){
                private int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < this.size();
                }

                @Override
                public GeoShapeValues.GeoShapeValue next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return value;
                }
            };
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        private final GeoFormatterFactory<Geometry> geoFormatterFactory;

        public TypeParser(GeoFormatterFactory<Geometry> geoFormatterFactory) {
            this.geoFormatterFactory = geoFormatterFactory;
        }

        @Override
        public Mapper.Builder parse(String name, Map<String, Object> node, MappingParserContext parserContext) throws MapperParsingException {
            Builder builder;
            boolean ignoreMalformedByDefault = FieldMapper.IGNORE_MALFORMED_SETTING.get(parserContext.getSettings());
            boolean coerceByDefault = FieldMapper.COERCE_SETTING.get(parserContext.getSettings());
            if (LegacyGeoShapeFieldMapper.containsDeprecatedParameter(node.keySet())) {
                if (parserContext.indexVersionCreated().onOrAfter(IndexVersions.V_8_0_0)) {
                    Set deprecatedParams = LegacyGeoShapeFieldMapper.getDeprecatedParameters(node.keySet());
                    throw new IllegalArgumentException("using deprecated parameters " + Arrays.toString(deprecatedParams.toArray()) + " in mapper [" + name + "] of type [geo_shape] is no longer allowed");
                }
                builder = new LegacyGeoShapeFieldMapper.Builder(name, parserContext.indexVersionCreated(), ignoreMalformedByDefault, coerceByDefault);
            } else {
                builder = new Builder(name, parserContext.indexVersionCreated(), parserContext.scriptCompiler(), ignoreMalformedByDefault, coerceByDefault, this.geoFormatterFactory);
            }
            builder.parse(name, parserContext, node);
            return builder;
        }
    }
}

