/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.support;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpHost;
import org.elasticsearch.common.settings.Setting;

public final class SecuritySettingsUtil {
    public static void verifyNonNullNotEmpty(String settingKey, String settingValue) {
        SecuritySettingsUtil.verifyNonNullNotEmpty(settingKey, settingValue, null);
    }

    public static void verifyNonNullNotEmpty(String settingKey, String settingValue, Collection<String> allowedValues) {
        assert (settingValue != null) : "Invalid null value for [" + settingKey + "].";
        if (settingValue.isEmpty()) {
            throw new IllegalArgumentException("Invalid empty value for [" + settingKey + "].");
        }
        if (allowedValues != null && !allowedValues.contains(settingValue)) {
            throw new IllegalArgumentException("Invalid value [" + settingValue + "] for [" + settingKey + "]. Allowed values are " + String.valueOf(allowedValues) + ".");
        }
    }

    public static void verifyNonNullNotEmpty(String settingKey, List<String> settingValues) {
        SecuritySettingsUtil.verifyNonNullNotEmpty(settingKey, settingValues, null);
    }

    public static void verifyNonNullNotEmpty(String settingKey, List<String> settingValues, Collection<String> allowedValues) {
        assert (settingValues != null) : "Invalid null list of values for [" + settingKey + "].";
        if (settingValues.isEmpty()) {
            if (allowedValues == null) {
                throw new IllegalArgumentException("Invalid empty list for [" + settingKey + "].");
            }
            throw new IllegalArgumentException("Invalid empty list for [" + settingKey + "]. Allowed values are " + String.valueOf(allowedValues) + ".");
        }
        for (String settingValue : settingValues) {
            SecuritySettingsUtil.verifyNonNullNotEmpty(settingKey, settingValue, allowedValues);
        }
    }

    public static void verifyProxySettings(String key, String hostValue, Map<Setting<?>, Object> settings, Setting.AffixSetting<String> hostKey, Setting.AffixSetting<String> schemeKey, Setting.AffixSetting<Integer> portKey) {
        String namespace = hostKey.getNamespace(hostKey.getConcreteSetting(key));
        Setting<Integer> portSetting = portKey.getConcreteSettingForNamespace(namespace);
        Integer port = (Integer)settings.get(portSetting);
        Setting<String> schemeSetting = schemeKey.getConcreteSettingForNamespace(namespace);
        String scheme = (String)settings.get(schemeSetting);
        try {
            new HttpHost(hostValue, (int)port, scheme);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("HTTP host for hostname [" + hostValue + "] (from [" + key + "]), port [" + port + "] (from [" + portSetting.getKey() + "]) and scheme [" + scheme + "] (from ([" + schemeSetting.getKey() + "]) is invalid");
        }
    }

    private SecuritySettingsUtil() {
        throw new IllegalAccessError("not allowed!");
    }
}

