/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.oidc;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class OpenIdConnectPrepareAuthenticationResponse
extends ActionResponse
implements ToXContentObject {
    private final String authenticationRequestUrl;
    private final String state;
    private final String nonce;
    private final String realmName;

    public OpenIdConnectPrepareAuthenticationResponse(String authorizationEndpointUrl, String state, String nonce, String realmName) {
        this.authenticationRequestUrl = authorizationEndpointUrl;
        this.state = state;
        this.nonce = nonce;
        this.realmName = realmName;
    }

    public String getAuthenticationRequestUrl() {
        return this.authenticationRequestUrl;
    }

    public String getState() {
        return this.state;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getRealmName() {
        return this.realmName;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.authenticationRequestUrl);
        out.writeString(this.state);
        out.writeString(this.nonce);
        out.writeString(this.realmName);
    }

    public String toString() {
        return "{authenticationRequestUrl=" + this.authenticationRequestUrl + ", state=" + this.state + ", nonce=" + this.nonce + ", realmName" + this.realmName + "}";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("redirect", this.authenticationRequestUrl);
        builder.field("state", this.state);
        builder.field("nonce", this.nonce);
        if (this.realmName != null) {
            builder.field("realm", this.realmName);
        }
        builder.endObject();
        return builder;
    }
}

