/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.apikey;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.CheckedBiFunction;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.security.action.apikey.UpdateApiKeyRequest;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;

public interface UpdateApiKeyRequestTranslator {
    public UpdateApiKeyRequest translate(RestRequest var1) throws IOException;

    public static class Default
    implements UpdateApiKeyRequestTranslator {
        private static final RoleDescriptor.Parser ROLE_DESCRIPTOR_PARSER = RoleDescriptor.parserBuilder().allowRestriction(true).build();
        private static final ConstructingObjectParser<Payload, Void> PARSER = Default.createParser(ROLE_DESCRIPTOR_PARSER::parse);

        protected static ConstructingObjectParser<Payload, Void> createParser(CheckedBiFunction<String, XContentParser, RoleDescriptor, IOException> roleDescriptorParser) {
            ConstructingObjectParser<Payload, Void> parser = new ConstructingObjectParser<Payload, Void>("update_api_key_request_payload", a -> new Payload((List)a[0], (Map)a[1], TimeValue.parseTimeValue((String)a[2], null, "expiration")));
            parser.declareNamedObjects(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> {
                p.nextToken();
                return (RoleDescriptor)roleDescriptorParser.apply(n, p);
            }, new ParseField("role_descriptors", new String[0]));
            parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), new ParseField("metadata", new String[0]));
            parser.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("expiration", new String[0]));
            return parser;
        }

        @Override
        public UpdateApiKeyRequest translate(RestRequest request) throws IOException {
            String apiKeyId = request.param("ids");
            if (!request.hasContent()) {
                return UpdateApiKeyRequest.usingApiKeyId(apiKeyId);
            }
            Payload payload = PARSER.parse(request.contentParser(), null);
            return new UpdateApiKeyRequest(apiKeyId, payload.roleDescriptors, payload.metadata, payload.expiration);
        }

        protected record Payload(List<RoleDescriptor> roleDescriptors, Map<String, Object> metadata, TimeValue expiration) {
        }
    }
}

