/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.apikey;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.common.CheckedBiFunction;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.security.action.apikey.CreateApiKeyAction;
import org.elasticsearch.xpack.core.security.action.apikey.CreateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.CreateApiKeyResponse;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;

public class CreateApiKeyRequestBuilder
extends ActionRequestBuilder<CreateApiKeyRequest, CreateApiKeyResponse> {
    private static final RoleDescriptor.Parser ROLE_DESCRIPTOR_PARSER = RoleDescriptor.parserBuilder().allowRestriction(true).build();
    private static final ConstructingObjectParser<CreateApiKeyRequest, Void> PARSER = CreateApiKeyRequestBuilder.createParser(ROLE_DESCRIPTOR_PARSER::parse);

    public static ConstructingObjectParser<CreateApiKeyRequest, Void> createParser(CheckedBiFunction<String, XContentParser, RoleDescriptor, IOException> roleDescriptorParser) {
        ConstructingObjectParser<CreateApiKeyRequest, Void> parser = new ConstructingObjectParser<CreateApiKeyRequest, Void>("api_key_request", false, (args, v) -> new CreateApiKeyRequest((String)args[0], (List)args[1], TimeValue.parseTimeValue((String)args[2], null, "expiration"), (Map)args[3]));
        parser.declareString(ConstructingObjectParser.constructorArg(), new ParseField("name", new String[0]));
        parser.declareNamedObjects(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> {
            p.nextToken();
            return (RoleDescriptor)roleDescriptorParser.apply(n, p);
        }, new ParseField("role_descriptors", new String[0]));
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("expiration", new String[0]));
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), new ParseField("metadata", new String[0]));
        return parser;
    }

    public CreateApiKeyRequestBuilder(ElasticsearchClient client) {
        super(client, CreateApiKeyAction.INSTANCE, new CreateApiKeyRequest());
    }

    public CreateApiKeyRequestBuilder setName(String name) {
        ((CreateApiKeyRequest)this.request).setName(name);
        return this;
    }

    public CreateApiKeyRequestBuilder setExpiration(TimeValue expiration) {
        ((CreateApiKeyRequest)this.request).setExpiration(expiration);
        return this;
    }

    public CreateApiKeyRequestBuilder setRoleDescriptors(List<RoleDescriptor> roleDescriptors) {
        ((CreateApiKeyRequest)this.request).setRoleDescriptors(roleDescriptors);
        return this;
    }

    public CreateApiKeyRequestBuilder setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
        ((CreateApiKeyRequest)this.request).setRefreshPolicy(refreshPolicy);
        return this;
    }

    public CreateApiKeyRequestBuilder setMetadata(Map<String, Object> metadata) {
        ((CreateApiKeyRequest)this.request).setMetadata(metadata);
        return this;
    }

    public CreateApiKeyRequestBuilder source(BytesReference source, XContentType xContentType) throws IOException {
        CreateApiKeyRequest createApiKeyRequest = this.parse(source, xContentType);
        this.setName(createApiKeyRequest.getName());
        this.setRoleDescriptors(createApiKeyRequest.getRoleDescriptors());
        this.setExpiration(createApiKeyRequest.getExpiration());
        this.setMetadata(createApiKeyRequest.getMetadata());
        return this;
    }

    protected CreateApiKeyRequest parse(BytesReference source, XContentType xContentType) throws IOException {
        try (XContentParser parser = XContentHelper.createParserNotCompressed(LoggingDeprecationHandler.XCONTENT_PARSER_CONFIG, source, xContentType);){
            CreateApiKeyRequest createApiKeyRequest = CreateApiKeyRequestBuilder.parse(parser);
            return createApiKeyRequest;
        }
    }

    public static CreateApiKeyRequest parse(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }
}

