/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.utils;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.template.put.TransportPutComposableIndexTemplateAction;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.template.IndexTemplateConfig;

public final class MlIndexAndAlias {
    public static final String BWC_MAPPINGS_VERSION = "8.11.0";
    public static final String FIRST_INDEX_SIX_DIGIT_SUFFIX = "-000001";
    private static final Logger logger = LogManager.getLogger(MlIndexAndAlias.class);
    private static final Predicate<String> HAS_SIX_DIGIT_SUFFIX = Pattern.compile("\\d{6}").asMatchPredicate();
    static final Comparator<String> INDEX_NAME_COMPARATOR = (index1, index2) -> {
        String[] index1Parts = index1.split("-");
        String index1Suffix = index1Parts[index1Parts.length - 1];
        boolean index1HasSixDigitsSuffix = HAS_SIX_DIGIT_SUFFIX.test(index1Suffix);
        String[] index2Parts = index2.split("-");
        String index2Suffix = index2Parts[index2Parts.length - 1];
        boolean index2HasSixDigitsSuffix = HAS_SIX_DIGIT_SUFFIX.test(index2Suffix);
        if (index1HasSixDigitsSuffix && index2HasSixDigitsSuffix) {
            return index1Suffix.compareTo(index2Suffix);
        }
        if (index1HasSixDigitsSuffix != index2HasSixDigitsSuffix) {
            return Boolean.compare(index1HasSixDigitsSuffix, index2HasSixDigitsSuffix);
        }
        return index1.compareTo((String)index2);
    };

    private MlIndexAndAlias() {
    }

    public static void createIndexAndAliasIfNecessary(Client client, ClusterState clusterState, IndexNameExpressionResolver resolver, String indexPatternPrefix, String alias, TimeValue masterNodeTimeout, ActiveShardCount waitForShardCount, ActionListener<Boolean> finalListener) {
        MlIndexAndAlias.createIndexAndAliasIfNecessary(client, clusterState, resolver, indexPatternPrefix, FIRST_INDEX_SIX_DIGIT_SUFFIX, alias, masterNodeTimeout, waitForShardCount, finalListener);
    }

    public static void createIndexAndAliasIfNecessary(Client client, ClusterState clusterState, IndexNameExpressionResolver resolver, String indexPatternPrefix, String indexNumber, String alias, TimeValue masterNodeTimeout, ActiveShardCount waitForShardCount, ActionListener<Boolean> finalListener) {
        Optional indexPointedByCurrentWriteAlias;
        ActionListener<Boolean> loggingListener = ActionListener.wrap(finalListener::onResponse, e -> {
            logger.error(() -> Strings.format("Failed to create alias and index with pattern [%s] and alias [%s]", indexPatternPrefix, alias), (Throwable)e);
            finalListener.onFailure((Exception)e);
        });
        ActionListener<Boolean> indexCreatedListener = loggingListener.delegateFailureAndWrap((delegate, created) -> {
            if (created.booleanValue()) {
                MlIndexAndAlias.waitForShardsReady(client, alias, masterNodeTimeout, delegate);
            } else {
                delegate.onResponse(false);
            }
        });
        String legacyIndexWithoutSuffix = indexPatternPrefix;
        String indexPattern = indexPatternPrefix + "*";
        String firstConcreteIndex = indexPatternPrefix + indexNumber;
        String[] concreteIndexNames = resolver.concreteIndexNames(clusterState, IndicesOptions.lenientExpandHidden(), indexPattern);
        Optional<Object> optional = indexPointedByCurrentWriteAlias = clusterState.getMetadata().getProject().hasAlias(alias) ? ((IndexAbstraction)clusterState.getMetadata().getProject().getIndicesLookup().get(alias)).getIndices().stream().map(Index::getName).findFirst() : Optional.empty();
        if (concreteIndexNames.length == 0) {
            if (indexPointedByCurrentWriteAlias.isEmpty()) {
                MlIndexAndAlias.createFirstConcreteIndex(client, firstConcreteIndex, alias, true, waitForShardCount, masterNodeTimeout, indexCreatedListener);
                return;
            }
            logger.error("There are no indices matching '{}' pattern but '{}' alias points at [{}]. This should never happen.", (Object)indexPattern, (Object)alias, indexPointedByCurrentWriteAlias.get());
        } else if (concreteIndexNames.length == 1 && concreteIndexNames[0].equals(legacyIndexWithoutSuffix)) {
            if (indexPointedByCurrentWriteAlias.isEmpty()) {
                MlIndexAndAlias.createFirstConcreteIndex(client, firstConcreteIndex, alias, true, waitForShardCount, masterNodeTimeout, indexCreatedListener);
                return;
            }
            if (((String)indexPointedByCurrentWriteAlias.get()).equals(legacyIndexWithoutSuffix)) {
                MlIndexAndAlias.createFirstConcreteIndex(client, firstConcreteIndex, alias, false, waitForShardCount, masterNodeTimeout, indexCreatedListener.delegateFailureAndWrap((l, unused) -> MlIndexAndAlias.updateWriteAlias(client, alias, legacyIndexWithoutSuffix, firstConcreteIndex, masterNodeTimeout, l)));
                return;
            }
            logger.error("There is exactly one index (i.e. '{}') matching '{}' pattern but '{}' alias points at [{}]. This should never happen.", (Object)legacyIndexWithoutSuffix, (Object)indexPattern, (Object)alias, indexPointedByCurrentWriteAlias.get());
        } else if (indexPointedByCurrentWriteAlias.isEmpty()) {
            assert (concreteIndexNames.length > 0);
            String latestConcreteIndexName = MlIndexAndAlias.latestIndex(concreteIndexNames);
            MlIndexAndAlias.updateWriteAlias(client, alias, null, latestConcreteIndexName, masterNodeTimeout, loggingListener);
            return;
        }
        loggingListener.onResponse(false);
    }

    public static void createSystemIndexIfNecessary(Client client, ClusterState clusterState, SystemIndexDescriptor descriptor, TimeValue masterNodeTimeout, ActionListener<Boolean> finalListener) {
        String primaryIndex = descriptor.getPrimaryIndex();
        if (clusterState.getMetadata().getProject().hasIndexAbstraction(primaryIndex)) {
            finalListener.onResponse(true);
            return;
        }
        ActionListener<Boolean> indexCreatedListener = ActionListener.wrap(created -> {
            if (created.booleanValue()) {
                MlIndexAndAlias.waitForShardsReady(client, primaryIndex, masterNodeTimeout, finalListener);
            } else {
                finalListener.onResponse(false);
            }
        }, e -> {
            if (ExceptionsHelper.unwrapCause(e) instanceof ResourceAlreadyExistsException) {
                finalListener.onResponse(true);
            } else {
                finalListener.onFailure((Exception)e);
            }
        });
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(primaryIndex);
        createIndexRequest.settings(descriptor.getSettings());
        createIndexRequest.mapping(descriptor.getMappings());
        createIndexRequest.origin("ml");
        createIndexRequest.masterNodeTimeout(masterNodeTimeout);
        ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", createIndexRequest, indexCreatedListener.delegateFailureAndWrap((l, r) -> l.onResponse(r.isAcknowledged())), client.admin().indices()::create);
    }

    private static void waitForShardsReady(Client client, String index, TimeValue masterNodeTimeout, ActionListener<Boolean> listener) {
        ClusterHealthRequest healthRequest = new ClusterHealthRequest(masterNodeTimeout, index).waitForYellowStatus().waitForNoRelocatingShards(true).waitForNoInitializingShards(true);
        ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", healthRequest, listener.delegateFailureAndWrap((l, response) -> l.onResponse(!response.isTimedOut())), client.admin().cluster()::health);
    }

    private static void createFirstConcreteIndex(Client client, String index, String alias, boolean addAlias, ActiveShardCount waitForShardCount, TimeValue masterNodeTimeout, ActionListener<Boolean> listener) {
        logger.info("About to create first concrete index [{}] with alias [{}]", (Object)index, (Object)alias);
        CreateIndexRequestBuilder requestBuilder = client.admin().indices().prepareCreate(index);
        if (addAlias) {
            requestBuilder.addAlias(new Alias(alias).isHidden(true));
        }
        requestBuilder.setWaitForActiveShards(waitForShardCount);
        CreateIndexRequest request = (CreateIndexRequest)requestBuilder.request();
        ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", request, ActionListener.wrap(createIndexResponse -> listener.onResponse(true), createIndexFailure -> {
            if (ExceptionsHelper.unwrapCause(createIndexFailure) instanceof ResourceAlreadyExistsException) {
                if (addAlias) {
                    MlIndexAndAlias.updateWriteAlias(client, alias, null, index, masterNodeTimeout, listener);
                } else {
                    listener.onResponse(true);
                }
            } else {
                listener.onFailure((Exception)createIndexFailure);
            }
        }), client.admin().indices()::create);
    }

    public static void updateWriteAlias(Client client, String alias, @Nullable String currentIndex, String newIndex, TimeValue masterNodeTimeout, ActionListener<Boolean> listener) {
        if (currentIndex != null) {
            logger.info("About to move write alias [{}] from index [{}] to index [{}]", (Object)alias, (Object)currentIndex, (Object)newIndex);
        } else {
            logger.info("About to create write alias [{}] for index [{}]", (Object)alias, (Object)newIndex);
        }
        IndicesAliasesRequestBuilder requestBuilder = client.admin().indices().prepareAliases(masterNodeTimeout, masterNodeTimeout).addAliasAction(IndicesAliasesRequest.AliasActions.add().index(newIndex).alias(alias).isHidden(true).writeIndex(true));
        if (currentIndex != null) {
            requestBuilder.removeAlias(currentIndex, alias);
        }
        IndicesAliasesRequest request = (IndicesAliasesRequest)requestBuilder.request();
        ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", request, listener.delegateFailureAndWrap((l, resp) -> l.onResponse(resp.isAcknowledged())), client.admin().indices()::aliases);
    }

    public static void installIndexTemplateIfRequired(ClusterState clusterState, Client client, IndexTemplateConfig templateConfig, TimeValue masterTimeout, ActionListener<Boolean> listener) {
        TransportPutComposableIndexTemplateAction.Request request;
        String templateName = templateConfig.getTemplateName();
        if (MlIndexAndAlias.hasIndexTemplate(clusterState, templateName, templateConfig.getVersion())) {
            listener.onResponse(true);
            return;
        }
        try (XContentParser parser = JsonXContent.jsonXContent.createParser(XContentParserConfiguration.EMPTY, templateConfig.loadBytes());){
            request = (TransportPutComposableIndexTemplateAction.Request)new TransportPutComposableIndexTemplateAction.Request(templateConfig.getTemplateName()).indexTemplate(ComposableIndexTemplate.parse(parser)).masterNodeTimeout(masterTimeout);
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("unable to parse composable template " + templateConfig.getTemplateName(), (Throwable)e, new Object[0]);
        }
        MlIndexAndAlias.installIndexTemplateIfRequired(clusterState, client, templateConfig.getVersion(), request, listener);
    }

    public static void installIndexTemplateIfRequired(ClusterState clusterState, Client client, int templateVersion, TransportPutComposableIndexTemplateAction.Request templateRequest, ActionListener<Boolean> listener) {
        if (MlIndexAndAlias.hasIndexTemplate(clusterState, templateRequest.name(), templateVersion)) {
            listener.onResponse(true);
            return;
        }
        ActionListener<AcknowledgedResponse> innerListener = listener.delegateFailureAndWrap((l, response) -> {
            if (!response.isAcknowledged()) {
                logger.warn("error adding template [{}], request was not acknowledged", (Object)templateRequest.name());
            }
            l.onResponse(response.isAcknowledged());
        });
        ClientHelper.executeAsyncWithOrigin(client, "ml", TransportPutComposableIndexTemplateAction.TYPE, templateRequest, innerListener);
    }

    public static boolean hasIndexTemplate(ClusterState state, String templateName, long version) {
        ComposableIndexTemplate template = state.getMetadata().getProject().templatesV2().get(templateName);
        return template != null && Long.valueOf(version).equals(template.version());
    }

    public static boolean has6DigitSuffix(String indexName) {
        String[] indexParts = indexName.split("-");
        String suffix = indexParts[indexParts.length - 1];
        return HAS_SIX_DIGIT_SUFFIX.test(suffix);
    }

    public static String latestIndex(String[] concreteIndices) {
        return concreteIndices.length == 1 ? concreteIndices[0] : Arrays.stream(concreteIndices).max(INDEX_NAME_COMPARATOR).get();
    }

    public static boolean indexIsReadWriteCompatibleInV9(IndexVersion version) {
        return version.onOrAfter(IndexVersions.V_8_0_0);
    }
}

