/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.Optional;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.AbstractTokenizationUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.MPNetTokenization;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.Tokenization;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class MPNetTokenizationUpdate
extends AbstractTokenizationUpdate {
    public static final ParseField NAME = MPNetTokenization.NAME;
    public static ConstructingObjectParser<MPNetTokenizationUpdate, Void> PARSER = new ConstructingObjectParser("mpnet_tokenization_update", a -> new MPNetTokenizationUpdate(a[0] == null ? null : Tokenization.Truncate.fromString((String)a[0]), (Integer)a[1]));

    public static MPNetTokenizationUpdate fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public MPNetTokenizationUpdate(@Nullable Tokenization.Truncate truncate, @Nullable Integer span) {
        super(truncate, span);
    }

    public MPNetTokenizationUpdate(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public Tokenization apply(Tokenization originalConfig) {
        if (!(originalConfig instanceof MPNetTokenization)) {
            throw ExceptionsHelper.badRequestException("Tokenization config of type [{}] can not be updated with a request of type [{}]", originalConfig.getName(), this.getName());
        }
        if (this.isNoop()) {
            return originalConfig;
        }
        if (this.getTruncate() != null && !this.getTruncate().isInCompatibleWithSpan()) {
            return new MPNetTokenization(originalConfig.doLowerCase(), originalConfig.withSpecialTokens(), originalConfig.maxSequenceLength(), this.getTruncate(), null);
        }
        return new MPNetTokenization(originalConfig.doLowerCase(), originalConfig.withSpecialTokens(), originalConfig.maxSequenceLength(), Optional.ofNullable(this.getTruncate()).orElse(originalConfig.getTruncate()), Optional.ofNullable(this.getSpan()).orElse(originalConfig.getSpan()));
    }

    @Override
    public String getWriteableName() {
        return MPNetTokenization.NAME.getPreferredName();
    }

    @Override
    public String getName() {
        return MPNetTokenization.NAME.getPreferredName();
    }

    static {
        MPNetTokenizationUpdate.declareCommonParserFields(PARSER);
    }
}

