/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class CancelJobModelSnapshotUpgradeAction
extends ActionType<Response> {
    public static final CancelJobModelSnapshotUpgradeAction INSTANCE = new CancelJobModelSnapshotUpgradeAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/model_snapshots/upgrade/cancel";

    private CancelJobModelSnapshotUpgradeAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements Writeable,
    ToXContentObject {
        private final boolean cancelled;

        public Response(boolean cancelled) {
            this.cancelled = cancelled;
        }

        public Response(StreamInput in) throws IOException {
            this.cancelled = in.readBoolean();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.cancelled);
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("cancelled", this.cancelled);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return this.cancelled == response.cancelled;
        }

        public int hashCode() {
            return Objects.hash(this.cancelled);
        }
    }

    public static class Request
    extends LegacyActionRequest
    implements ToXContentObject {
        public static final String ALL = "_all";
        public static final ParseField SNAPSHOT_ID = new ParseField("snapshot_id", new String[0]);
        public static final ParseField ALLOW_NO_MATCH = new ParseField("allow_no_match", new String[0]);
        static final ObjectParser<Request, Void> PARSER = new ObjectParser("cluster:admin/xpack/ml/job/model_snapshots/upgrade/cancel", Request::new);
        private String jobId = "_all";
        private String snapshotId = "_all";
        private boolean allowNoMatch = true;

        public Request() {
        }

        public Request(String jobId, String snapshotId) {
            this.setJobId(jobId);
            this.setSnapshotId(snapshotId);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.jobId = in.readString();
            this.snapshotId = in.readString();
            this.allowNoMatch = in.readBoolean();
        }

        public final Request setJobId(String jobId) {
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID);
            return this;
        }

        public String getJobId() {
            return this.jobId;
        }

        public final Request setSnapshotId(String snapshotId) {
            this.snapshotId = ExceptionsHelper.requireNonNull(snapshotId, Job.ID);
            return this;
        }

        public String getSnapshotId() {
            return this.snapshotId;
        }

        public boolean allowNoMatch() {
            return this.allowNoMatch;
        }

        public Request setAllowNoMatch(boolean allowNoMatch) {
            this.allowNoMatch = allowNoMatch;
            return this;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.jobId);
            out.writeString(this.snapshotId);
            out.writeBoolean(this.allowNoMatch);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field(Job.ID.getPreferredName(), this.jobId).field(SNAPSHOT_ID.getPreferredName(), this.snapshotId).field(ALLOW_NO_MATCH.getPreferredName(), this.allowNoMatch).endObject();
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.snapshotId, this.allowNoMatch);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Request other = (Request)obj;
            return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.snapshotId, other.snapshotId) && this.allowNoMatch == other.allowNoMatch;
        }

        @Override
        public String toString() {
            return Strings.toString(this);
        }

        static {
            PARSER.declareString(Request::setJobId, Job.ID);
            PARSER.declareString(Request::setSnapshotId, SNAPSHOT_ID);
            PARSER.declareBoolean(Request::setAllowNoMatch, ALLOW_NO_MATCH);
        }
    }
}

