/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.Index;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ilm.ClusterStateWaitStep;
import org.elasticsearch.xpack.core.ilm.ShrinkIndexNameSupplier;
import org.elasticsearch.xpack.core.ilm.Step;

public class ShrunkShardsAllocatedStep
extends ClusterStateWaitStep {
    public static final String NAME = "shrunk-shards-allocated";
    private static final Logger logger = LogManager.getLogger(ShrunkShardsAllocatedStep.class);

    public ShrunkShardsAllocatedStep(Step.StepKey key, Step.StepKey nextStepKey) {
        super(key, nextStepKey);
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    public ClusterStateWaitStep.Result isConditionMet(Index index, ProjectState currentState) {
        boolean indexExists;
        IndexMetadata indexMetadata = currentState.metadata().index(index);
        if (indexMetadata == null) {
            logger.debug("[{}] lifecycle action for index [{}] executed but index no longer exists", (Object)this.getKey().action(), (Object)index.getName());
            return new ClusterStateWaitStep.Result(false, null);
        }
        LifecycleExecutionState lifecycleState = indexMetadata.getLifecycleExecutionState();
        String shrunkenIndexName = ShrinkIndexNameSupplier.getShrinkIndexName(indexMetadata.getIndex().getName(), lifecycleState);
        boolean bl = indexExists = currentState.metadata().index(shrunkenIndexName) != null;
        if (!indexExists) {
            return new ClusterStateWaitStep.Result(false, new Info(false, -1, false));
        }
        boolean allShardsActive = ActiveShardCount.ALL.enoughShardsActive(currentState.metadata(), currentState.routingTable(), shrunkenIndexName);
        int numShrunkIndexShards = currentState.metadata().index(shrunkenIndexName).getNumberOfShards();
        if (allShardsActive) {
            return new ClusterStateWaitStep.Result(true, null);
        }
        return new ClusterStateWaitStep.Result(false, new Info(true, numShrunkIndexShards, allShardsActive));
    }

    public static final class Info
    implements ToXContentObject {
        private final int actualShards;
        private final boolean shrunkIndexExists;
        private final boolean allShardsActive;
        private final String message;
        static final ParseField ACTUAL_SHARDS = new ParseField("actual_shards", new String[0]);
        static final ParseField SHRUNK_INDEX_EXISTS = new ParseField("shrunk_index_exists", new String[0]);
        static final ParseField ALL_SHARDS_ACTIVE = new ParseField("all_shards_active", new String[0]);
        static final ParseField MESSAGE = new ParseField("message", new String[0]);
        static final ConstructingObjectParser<Info, Void> PARSER = new ConstructingObjectParser("shrunk_shards_allocated_step_info", a -> new Info((Boolean)a[0], (Integer)a[1], (Boolean)a[2]));

        public Info(boolean shrunkIndexExists, int actualShards, boolean allShardsActive) {
            this.actualShards = actualShards;
            this.shrunkIndexExists = shrunkIndexExists;
            this.allShardsActive = allShardsActive;
            this.message = !shrunkIndexExists ? "Waiting for shrunk index to be created" : (!allShardsActive ? "Waiting for all shard copies to be active" : "");
        }

        public int getActualShards() {
            return this.actualShards;
        }

        public boolean shrunkIndexExists() {
            return this.shrunkIndexExists;
        }

        public boolean allShardsActive() {
            return this.allShardsActive;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(MESSAGE.getPreferredName(), this.message);
            builder.field(SHRUNK_INDEX_EXISTS.getPreferredName(), this.shrunkIndexExists);
            builder.field(ACTUAL_SHARDS.getPreferredName(), this.actualShards);
            builder.field(ALL_SHARDS_ACTIVE.getPreferredName(), this.allShardsActive);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.shrunkIndexExists, this.actualShards, this.allShardsActive);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Info other = (Info)obj;
            return Objects.equals(this.shrunkIndexExists, other.shrunkIndexExists) && Objects.equals(this.actualShards, other.actualShards) && Objects.equals(this.allShardsActive, other.allShardsActive);
        }

        public String toString() {
            return Strings.toString(this);
        }

        static {
            PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), SHRUNK_INDEX_EXISTS);
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), ACTUAL_SHARDS);
            PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), ALL_SHARDS_ACTIVE);
            PARSER.declareString((i, s) -> {}, MESSAGE);
        }
    }
}

