/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.repositories.ProjectRepo;
import org.elasticsearch.repositories.RepositoryShardId;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotFeatureInfo;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotShardFailure;
import org.elasticsearch.snapshots.SnapshotState;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class SnapshotInfo
implements Comparable<SnapshotInfo>,
ToXContentFragment,
Writeable {
    public static final String INDEX_DETAILS_XCONTENT_PARAM = "index_details";
    public static final String INDEX_NAMES_XCONTENT_PARAM = "index_names";
    public static final String INCLUDE_REPOSITORY_XCONTENT_PARAM = "include_repository";
    private static final DateFormatter DATE_TIME_FORMATTER = DateFormatter.forPattern("strict_date_optional_time");
    static final String SNAPSHOT = "snapshot";
    static final String UUID = "uuid";
    static final String REPOSITORY = "repository";
    static final String INDICES = "indices";
    static final String DATA_STREAMS = "data_streams";
    static final String STATE = "state";
    static final String REASON = "reason";
    static final String START_TIME = "start_time";
    static final String START_TIME_IN_MILLIS = "start_time_in_millis";
    static final String END_TIME = "end_time";
    static final String END_TIME_IN_MILLIS = "end_time_in_millis";
    static final String DURATION = "duration";
    static final String DURATION_IN_MILLIS = "duration_in_millis";
    static final String FAILURES = "failures";
    static final String SHARDS = "shards";
    static final String TOTAL = "total";
    static final String FAILED = "failed";
    static final String SUCCESSFUL = "successful";
    static final String VERSION_ID = "version_id";
    static final String VERSION = "version";
    static final String NAME = "name";
    static final String TOTAL_SHARDS = "total_shards";
    static final String SUCCESSFUL_SHARDS = "successful_shards";
    static final String INCLUDE_GLOBAL_STATE = "include_global_state";
    static final String USER_METADATA = "metadata";
    static final String FEATURE_STATES = "feature_states";
    static final String INDEX_DETAILS = "index_details";
    static final String UNKNOWN_REPO_NAME = "_na_";
    private static final Comparator<SnapshotInfo> COMPARATOR = Comparator.comparing(SnapshotInfo::startTime).thenComparing(SnapshotInfo::snapshotId);
    private final Snapshot snapshot;
    @Nullable
    private final SnapshotState state;
    @Nullable
    private final String reason;
    private final List<String> indices;
    private final List<String> dataStreams;
    private final List<SnapshotFeatureInfo> featureStates;
    private final long startTime;
    private final long endTime;
    private final int totalShards;
    private final int successfulShards;
    @Nullable
    private final Boolean includeGlobalState;
    @Nullable
    private final Map<String, Object> userMetadata;
    @Nullable
    private final IndexVersion version;
    private final List<SnapshotShardFailure> shardFailures;
    private final Map<String, IndexSnapshotDetails> indexSnapshotDetails;

    public SnapshotInfo(Snapshot snapshot, List<String> indices, List<String> dataStreams, List<SnapshotFeatureInfo> featureStates, SnapshotState state) {
        this(snapshot, indices, dataStreams, featureStates, null, null, 0L, 0L, 0, 0, Collections.emptyList(), null, null, state, Collections.emptyMap());
    }

    public SnapshotInfo(Snapshot snapshot, List<String> indices, List<String> dataStreams, List<SnapshotFeatureInfo> featureStates, IndexVersion version, SnapshotState state) {
        this(snapshot, indices, dataStreams, featureStates, null, version, 0L, 0L, 0, 0, Collections.emptyList(), null, null, state, Collections.emptyMap());
    }

    public static SnapshotInfo inProgress(SnapshotsInProgress.Entry entry) {
        int successfulShards = 0;
        ArrayList<SnapshotShardFailure> shardFailures = new ArrayList<SnapshotShardFailure>();
        for (Map.Entry<RepositoryShardId, SnapshotsInProgress.ShardSnapshotStatus> c : entry.shardSnapshotStatusByRepoShardId().entrySet()) {
            if (c.getValue().state() == SnapshotsInProgress.ShardState.SUCCESS) {
                ++successfulShards;
                continue;
            }
            if (!c.getValue().state().failed() || !c.getValue().state().completed()) continue;
            shardFailures.add(new SnapshotShardFailure(c.getValue().nodeId(), entry.shardId(c.getKey()), c.getValue().reason()));
        }
        int totalShards = entry.shardSnapshotStatusByRepoShardId().size();
        return new SnapshotInfo(entry.snapshot(), List.copyOf(entry.indices().keySet()), entry.dataStreams(), entry.featureStates(), null, IndexVersion.current(), entry.startTime(), 0L, totalShards, successfulShards, shardFailures, entry.includeGlobalState(), entry.userMetadata(), SnapshotState.IN_PROGRESS, Collections.emptyMap());
    }

    public SnapshotInfo(Snapshot snapshot, List<String> indices, List<String> dataStreams, List<SnapshotFeatureInfo> featureStates, String reason, long endTime, int totalShards, List<SnapshotShardFailure> shardFailures, Boolean includeGlobalState, Map<String, Object> userMetadata, long startTime, Map<String, IndexSnapshotDetails> indexSnapshotDetails) {
        this(snapshot, indices, dataStreams, featureStates, reason, IndexVersion.current(), startTime, endTime, totalShards, totalShards - shardFailures.size(), shardFailures, includeGlobalState, userMetadata, SnapshotInfo.snapshotState(reason, shardFailures), indexSnapshotDetails);
    }

    public SnapshotInfo(Snapshot snapshot, List<String> indices, List<String> dataStreams, List<SnapshotFeatureInfo> featureStates, String reason, IndexVersion version, long startTime, long endTime, int totalShards, int successfulShards, List<SnapshotShardFailure> shardFailures, Boolean includeGlobalState, Map<String, Object> userMetadata, SnapshotState state, Map<String, IndexSnapshotDetails> indexSnapshotDetails) {
        this.snapshot = Objects.requireNonNull(snapshot);
        this.indices = List.copyOf(indices);
        this.dataStreams = List.copyOf(dataStreams);
        this.featureStates = List.copyOf(featureStates);
        this.state = state;
        this.reason = reason;
        this.version = version;
        this.startTime = startTime;
        this.endTime = endTime;
        this.totalShards = totalShards;
        this.successfulShards = successfulShards;
        this.shardFailures = List.copyOf(shardFailures);
        this.includeGlobalState = includeGlobalState;
        this.userMetadata = userMetadata == null ? null : Map.copyOf(userMetadata);
        this.indexSnapshotDetails = Map.copyOf(indexSnapshotDetails);
    }

    public SnapshotInfo maybeWithoutIndices(boolean retainIndices) {
        if (retainIndices || this.indices.isEmpty()) {
            return this;
        }
        return new SnapshotInfo(this.snapshot, List.of(), this.dataStreams, this.featureStates, this.reason, this.version, this.startTime, this.endTime, this.totalShards, this.successfulShards, this.shardFailures, this.includeGlobalState, this.userMetadata, this.state, this.indexSnapshotDetails);
    }

    public static SnapshotInfo readFrom(StreamInput in) throws IOException {
        Snapshot snapshot = new Snapshot(in);
        List<String> indices = in.readStringCollectionAsImmutableList();
        SnapshotState state = in.readBoolean() ? SnapshotState.fromValue(in.readByte()) : null;
        String reason = in.readOptionalString();
        long startTime = in.readVLong();
        long endTime = in.readVLong();
        int totalShards = in.readVInt();
        int successfulShards = in.readVInt();
        List<SnapshotShardFailure> shardFailures = in.readCollectionAsImmutableList(SnapshotShardFailure::new);
        IndexVersion version = in.readBoolean() ? IndexVersion.readVersion(in) : null;
        Boolean includeGlobalState = in.readOptionalBoolean();
        Map<String, Object> userMetadata = in.readGenericMap();
        List<String> dataStreams = in.readStringCollectionAsImmutableList();
        List<SnapshotFeatureInfo> featureStates = in.readCollectionAsImmutableList(SnapshotFeatureInfo::new);
        Map<String, IndexSnapshotDetails> indexSnapshotDetails = in.readImmutableMap(IndexSnapshotDetails::new);
        return new SnapshotInfo(snapshot, indices, dataStreams, featureStates, reason, version, startTime, endTime, totalShards, successfulShards, shardFailures, includeGlobalState, userMetadata, state, indexSnapshotDetails);
    }

    public SnapshotInfo basic() {
        return new SnapshotInfo(this.snapshot, this.indices, Collections.emptyList(), this.featureStates, this.state);
    }

    public Snapshot snapshot() {
        return this.snapshot;
    }

    public SnapshotId snapshotId() {
        return this.snapshot.getSnapshotId();
    }

    public ProjectId projectId() {
        return this.snapshot.getProjectId();
    }

    public String repository() {
        return this.snapshot.getRepository();
    }

    @Nullable
    public SnapshotState state() {
        return this.state;
    }

    @Nullable
    public String reason() {
        return this.reason;
    }

    public List<String> indices() {
        return this.indices;
    }

    public List<String> dataStreams() {
        return this.dataStreams;
    }

    public long startTime() {
        return this.startTime;
    }

    public long endTime() {
        return this.endTime;
    }

    public int totalShards() {
        return this.totalShards;
    }

    public int failedShards() {
        return this.shardFailures.size();
    }

    public int successfulShards() {
        return this.successfulShards;
    }

    public Boolean includeGlobalState() {
        return this.includeGlobalState;
    }

    public List<SnapshotShardFailure> shardFailures() {
        return this.shardFailures;
    }

    @Nullable
    public IndexVersion version() {
        return this.version;
    }

    @Nullable
    public Map<String, Object> userMetadata() {
        return this.userMetadata;
    }

    public List<SnapshotFeatureInfo> featureStates() {
        return this.featureStates;
    }

    public Map<String, IndexSnapshotDetails> indexSnapshotDetails() {
        return this.indexSnapshotDetails;
    }

    @Override
    public int compareTo(SnapshotInfo o) {
        return COMPARATOR.compare(this, o);
    }

    public String toString() {
        return "SnapshotInfo{snapshot=" + String.valueOf(this.snapshot) + ", state=" + String.valueOf((Object)this.state) + ", reason='" + this.reason + "', indices=" + String.valueOf(this.indices) + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", totalShards=" + this.totalShards + ", successfulShards=" + this.successfulShards + ", includeGlobalState=" + this.includeGlobalState + ", version=" + String.valueOf(this.version) + ", shardFailures=" + String.valueOf(this.shardFailures) + ", featureStates=" + String.valueOf(this.featureStates) + ", indexSnapshotDetails=" + String.valueOf(this.indexSnapshotDetails) + "}";
    }

    public RestStatus status() {
        if (this.state == SnapshotState.FAILED) {
            return RestStatus.INTERNAL_SERVER_ERROR;
        }
        if (this.shardFailures.size() == 0) {
            return RestStatus.OK;
        }
        return RestStatus.status(this.successfulShards, this.totalShards, this.shardFailures.toArray(new ShardOperationFailedException[this.shardFailures.size()]));
    }

    public XContentBuilder toXContentExternal(XContentBuilder builder, ToXContent.Params params) throws IOException {
        assert (!Metadata.CONTEXT_MODE_SNAPSHOT.equals(params.param("context_mode"))) : "use toXContent() in SNAPSHOT context";
        boolean verbose = params.paramAsBoolean("verbose", true);
        builder.startObject();
        SnapshotId snapshotId = this.snapshot.getSnapshotId();
        builder.field(SNAPSHOT, snapshotId.getName());
        builder.field(UUID, snapshotId.getUUID());
        if (params.paramAsBoolean(INCLUDE_REPOSITORY_XCONTENT_PARAM, true) && !UNKNOWN_REPO_NAME.equals(this.snapshot.getRepository())) {
            builder.field(REPOSITORY, this.snapshot.getRepository());
        }
        if (this.version != null) {
            builder.field(VERSION_ID, this.version.id());
            builder.field(VERSION, this.version.toReleaseVersion());
        }
        if (params.paramAsBoolean(INDEX_NAMES_XCONTENT_PARAM, true)) {
            builder.stringListField(INDICES, this.indices);
        }
        if (params.paramAsBoolean("index_details", false) && !this.indexSnapshotDetails.isEmpty()) {
            builder.startObject("index_details");
            for (Map.Entry entry : this.indexSnapshotDetails.entrySet()) {
                builder.field((String)entry.getKey());
                ((IndexSnapshotDetails)entry.getValue()).toXContent(builder, params);
            }
            builder.endObject();
        }
        builder.startArray(DATA_STREAMS);
        for (String string : this.dataStreams) {
            builder.value(string);
        }
        builder.endArray();
        if (this.includeGlobalState != null) {
            builder.field(INCLUDE_GLOBAL_STATE, this.includeGlobalState);
        }
        if (this.userMetadata != null) {
            builder.field(USER_METADATA, this.userMetadata);
        }
        if (verbose || this.state != null) {
            builder.field(STATE, this.state);
        }
        if (this.reason != null) {
            builder.field(REASON, this.reason);
        }
        if (verbose || this.startTime != 0L) {
            builder.field(START_TIME, DATE_TIME_FORMATTER.format(Instant.ofEpochMilli(this.startTime).atZone(ZoneOffset.UTC)));
            builder.field(START_TIME_IN_MILLIS, this.startTime);
        }
        if (verbose || this.endTime != 0L) {
            builder.field(END_TIME, DATE_TIME_FORMATTER.format(Instant.ofEpochMilli(this.endTime).atZone(ZoneOffset.UTC)));
            builder.field(END_TIME_IN_MILLIS, this.endTime);
            builder.humanReadableField(DURATION_IN_MILLIS, DURATION, new TimeValue(Math.max(0L, this.endTime - this.startTime)));
        }
        if (verbose || !this.shardFailures.isEmpty()) {
            builder.startArray(FAILURES);
            for (SnapshotShardFailure snapshotShardFailure : this.shardFailures) {
                snapshotShardFailure.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (verbose || this.totalShards != 0) {
            builder.startObject(SHARDS);
            builder.field(TOTAL, this.totalShards);
            builder.field(FAILED, this.failedShards());
            builder.field(SUCCESSFUL, this.successfulShards);
            builder.endObject();
        }
        if (verbose || !this.featureStates.isEmpty()) {
            builder.startArray(FEATURE_STATES);
            for (SnapshotFeatureInfo snapshotFeatureInfo : this.featureStates) {
                builder.value(snapshotFeatureInfo);
            }
            builder.endArray();
        }
        builder.endObject();
        return builder;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        assert (Metadata.CONTEXT_MODE_SNAPSHOT.equals(params.param("context_mode"))) : "use toXContentExternal() in external context";
        builder.startObject(SNAPSHOT);
        SnapshotId snapshotId = this.snapshot.getSnapshotId();
        builder.field(NAME, snapshotId.getName());
        builder.field(UUID, snapshotId.getUUID());
        assert (this.version != null) : "version must always be known when writing a snapshot metadata blob";
        builder.field(VERSION_ID, this.version.id());
        builder.startArray(INDICES);
        for (String string : this.indices) {
            builder.value(string);
        }
        builder.endArray();
        builder.startArray(DATA_STREAMS);
        for (String string : this.dataStreams) {
            builder.value(string);
        }
        builder.endArray();
        builder.field(STATE, this.state);
        if (this.reason != null) {
            builder.field(REASON, this.reason);
        }
        if (this.includeGlobalState != null) {
            builder.field(INCLUDE_GLOBAL_STATE, this.includeGlobalState);
        }
        if (this.userMetadata != null) {
            builder.field(USER_METADATA, this.userMetadata);
        }
        builder.field(START_TIME, this.startTime);
        builder.field(END_TIME, this.endTime);
        builder.field(TOTAL_SHARDS, this.totalShards);
        builder.field(SUCCESSFUL_SHARDS, this.successfulShards);
        builder.startArray(FAILURES);
        for (SnapshotShardFailure snapshotShardFailure : this.shardFailures) {
            snapshotShardFailure.toXContent(builder, params);
        }
        builder.endArray();
        builder.startArray(FEATURE_STATES);
        for (SnapshotFeatureInfo snapshotFeatureInfo : this.featureStates) {
            builder.value(snapshotFeatureInfo);
        }
        builder.endArray();
        builder.startObject("index_details");
        for (Map.Entry entry : this.indexSnapshotDetails.entrySet()) {
            builder.field((String)entry.getKey());
            ((IndexSnapshotDetails)entry.getValue()).toXContent(builder, params);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static SnapshotInfo fromXContentInternal(ProjectRepo projectRepo, XContentParser parser) throws IOException {
        String name = null;
        String uuid = null;
        IndexVersion version = IndexVersion.current();
        SnapshotState state = SnapshotState.IN_PROGRESS;
        String reason = null;
        List<String> indices = Collections.emptyList();
        List<String> dataStreams = Collections.emptyList();
        long startTime = 0L;
        long endTime = 0L;
        int totalShards = 0;
        int successfulShards = 0;
        Boolean includeGlobalState = null;
        Map<String, Object> userMetadata = null;
        List<SnapshotShardFailure> shardFailures = Collections.emptyList();
        List<SnapshotFeatureInfo> featureStates = Collections.emptyList();
        Map<String, IndexSnapshotDetails> indexSnapshotDetails = null;
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            parser.nextToken();
        }
        XContentParserUtils.ensureFieldName(parser, parser.currentToken(), SNAPSHOT);
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
        block36: while (parser.nextToken() == XContentParser.Token.FIELD_NAME) {
            String currentFieldName = parser.currentName();
            XContentParser.Token token = parser.nextToken();
            switch (currentFieldName) {
                case "name": {
                    name = parser.text();
                    continue block36;
                }
                case "uuid": {
                    uuid = parser.text();
                    continue block36;
                }
                case "state": {
                    state = SnapshotState.valueOf(parser.text());
                    continue block36;
                }
                case "reason": {
                    reason = parser.text();
                    continue block36;
                }
                case "start_time": {
                    startTime = parser.longValue();
                    continue block36;
                }
                case "end_time": {
                    endTime = parser.longValue();
                    continue block36;
                }
                case "total_shards": {
                    totalShards = parser.intValue();
                    continue block36;
                }
                case "successful_shards": {
                    successfulShards = parser.intValue();
                    continue block36;
                }
                case "version_id": {
                    version = IndexVersion.fromId(parser.intValue());
                    continue block36;
                }
                case "include_global_state": {
                    includeGlobalState = parser.booleanValue();
                    continue block36;
                }
                case "data_streams": {
                    dataStreams = XContentParserUtils.parseList(parser, XContentParser::text);
                    continue block36;
                }
                case "indices": {
                    indices = XContentParserUtils.parseList(parser, XContentParser::text);
                    continue block36;
                }
                case "failures": {
                    shardFailures = XContentParserUtils.parseList(parser, SnapshotShardFailure::fromXContent);
                    continue block36;
                }
                case "feature_states": {
                    featureStates = XContentParserUtils.parseList(parser, SnapshotFeatureInfo::fromXContent);
                    continue block36;
                }
                case "metadata": {
                    if (token == XContentParser.Token.VALUE_NULL) continue block36;
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
                    userMetadata = parser.map();
                    continue block36;
                }
                case "index_details": {
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
                    indexSnapshotDetails = parser.map(HashMap::new, p -> IndexSnapshotDetails.PARSER.parse((XContentParser)p, (Void)null));
                    continue block36;
                }
            }
            parser.skipChildren();
        }
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.END_OBJECT, parser.nextToken(), parser);
        if (uuid == null) {
            uuid = name;
        }
        return new SnapshotInfo(new Snapshot(projectRepo.projectId(), projectRepo.name(), new SnapshotId(name, uuid)), indices, dataStreams, featureStates, reason, version, startTime, endTime, totalShards, successfulShards, shardFailures, includeGlobalState, userMetadata, state, indexSnapshotDetails == null ? Collections.emptyMap() : indexSnapshotDetails);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.snapshot.writeTo(out);
        out.writeStringCollection(this.indices);
        if (this.state != null) {
            out.writeBoolean(true);
            out.writeByte(this.state.value());
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.reason);
        out.writeVLong(this.startTime);
        out.writeVLong(this.endTime);
        out.writeVInt(this.totalShards);
        out.writeVInt(this.successfulShards);
        out.writeCollection(this.shardFailures);
        if (this.version != null) {
            out.writeBoolean(true);
            IndexVersion.writeVersion(this.version, out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalBoolean(this.includeGlobalState);
        out.writeGenericMap(this.userMetadata);
        out.writeStringCollection(this.dataStreams);
        out.writeCollection(this.featureStates);
        out.writeMap(this.indexSnapshotDetails, StreamOutput::writeWriteable);
    }

    private static SnapshotState snapshotState(String reason, List<SnapshotShardFailure> shardFailures) {
        if (reason == null) {
            if (shardFailures.isEmpty()) {
                return SnapshotState.SUCCESS;
            }
            return SnapshotState.PARTIAL;
        }
        return SnapshotState.FAILED;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotInfo that = (SnapshotInfo)o;
        return this.startTime == that.startTime && this.endTime == that.endTime && this.totalShards == that.totalShards && this.successfulShards == that.successfulShards && Objects.equals(this.snapshot, that.snapshot) && this.state == that.state && Objects.equals(this.reason, that.reason) && Objects.equals(this.indices, that.indices) && Objects.equals(this.dataStreams, that.dataStreams) && Objects.equals(this.includeGlobalState, that.includeGlobalState) && Objects.equals(this.version, that.version) && Objects.equals(this.shardFailures, that.shardFailures) && Objects.equals(this.userMetadata, that.userMetadata) && Objects.equals(this.featureStates, that.featureStates) && Objects.equals(this.indexSnapshotDetails, that.indexSnapshotDetails);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.snapshot, this.state, this.reason, this.indices, this.dataStreams, this.startTime, this.endTime, this.totalShards, this.successfulShards, this.includeGlobalState, this.version, this.shardFailures, this.userMetadata, this.featureStates, this.indexSnapshotDetails});
    }

    public static class IndexSnapshotDetails
    implements ToXContentObject,
    Writeable {
        private static final String SHARD_COUNT = "shard_count";
        private static final String SIZE = "size_in_bytes";
        private static final String MAX_SEGMENTS_PER_SHARD = "max_segments_per_shard";
        public static final IndexSnapshotDetails SKIPPED = new IndexSnapshotDetails(0, ByteSizeValue.ZERO, 0);
        public static final ConstructingObjectParser<IndexSnapshotDetails, Void> PARSER = new ConstructingObjectParser(IndexSnapshotDetails.class.getName(), true, a -> new IndexSnapshotDetails((Integer)a[0], ByteSizeValue.ofBytes((Long)a[1]), (Integer)a[2]));
        private final int shardCount;
        private final ByteSizeValue size;
        private final int maxSegmentsPerShard;

        public IndexSnapshotDetails(int shardCount, ByteSizeValue size, int maxSegmentsPerShard) {
            this.shardCount = shardCount;
            this.size = Objects.requireNonNull(size);
            this.maxSegmentsPerShard = maxSegmentsPerShard;
        }

        public IndexSnapshotDetails(StreamInput in) throws IOException {
            this.shardCount = in.readVInt();
            this.size = ByteSizeValue.readFrom(in);
            this.maxSegmentsPerShard = in.readVInt();
        }

        public int getShardCount() {
            return this.shardCount;
        }

        public ByteSizeValue getSize() {
            return this.size;
        }

        public int getMaxSegmentsPerShard() {
            return this.maxSegmentsPerShard;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexSnapshotDetails that = (IndexSnapshotDetails)o;
            return this.shardCount == that.shardCount && this.maxSegmentsPerShard == that.maxSegmentsPerShard && this.size.equals(that.size);
        }

        public int hashCode() {
            return Objects.hash(this.shardCount, this.size, this.maxSegmentsPerShard);
        }

        public String toString() {
            return "IndexSnapshotDetails{shardCount=" + this.shardCount + ", size=" + String.valueOf(this.size) + ", maxSegmentsPerShard=" + this.maxSegmentsPerShard + "}";
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.shardCount);
            this.size.writeTo(out);
            out.writeVInt(this.maxSegmentsPerShard);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(SHARD_COUNT, this.shardCount);
            builder.humanReadableField(SIZE, "size", this.size);
            builder.field(MAX_SEGMENTS_PER_SHARD, this.maxSegmentsPerShard);
            builder.endObject();
            return builder;
        }

        static {
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(SHARD_COUNT, new String[0]));
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField(SIZE, new String[0]));
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(MAX_SEGMENTS_PER_SHARD, new String[0]));
        }
    }
}

