/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.snapshots.SnapshotId;

public final class Snapshot
implements Writeable {
    private final ProjectId projectId;
    private final String repository;
    private final SnapshotId snapshotId;
    private final int hashCode;

    @Deprecated(forRemoval=true)
    public Snapshot(String repository, SnapshotId snapshotId) {
        this(ProjectId.DEFAULT, repository, snapshotId);
    }

    public Snapshot(ProjectId projectId, String repository, SnapshotId snapshotId) {
        this.projectId = projectId;
        this.repository = Objects.requireNonNull(repository);
        this.snapshotId = Objects.requireNonNull(snapshotId);
        this.hashCode = this.computeHashCode();
    }

    public Snapshot(StreamInput in) throws IOException {
        this.projectId = in.getTransportVersion().before(TransportVersions.PROJECT_ID_IN_SNAPSHOT) ? ProjectId.DEFAULT : ProjectId.readFrom(in);
        this.repository = in.readString();
        this.snapshotId = new SnapshotId(in);
        this.hashCode = this.computeHashCode();
    }

    public ProjectId getProjectId() {
        return this.projectId;
    }

    public String getRepository() {
        return this.repository;
    }

    public SnapshotId getSnapshotId() {
        return this.snapshotId;
    }

    public String toString() {
        return String.valueOf(this.projectId) + ":" + this.repository + ":" + this.snapshotId.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Snapshot that = (Snapshot)o;
        return this.projectId.equals(that.projectId) && this.repository.equals(that.repository) && this.snapshotId.equals(that.snapshotId);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        return Objects.hash(this.projectId, this.repository, this.snapshotId);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().before(TransportVersions.PROJECT_ID_IN_SNAPSHOT)) {
            if (!ProjectId.DEFAULT.equals(this.projectId)) {
                String message = "Cannot write instance with non-default project id " + String.valueOf(this.projectId) + " to version before " + String.valueOf(TransportVersions.PROJECT_ID_IN_SNAPSHOT);
                assert (false) : message;
                throw new IllegalArgumentException(message);
            }
        } else {
            this.projectId.writeTo(out);
        }
        out.writeString(this.repository);
        this.snapshotId.writeTo(out);
    }
}

