/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.vectors;

import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.knn.KnnSearchStrategy;
import org.elasticsearch.index.codec.vectors.cluster.NeighborQueue;
import org.elasticsearch.search.vectors.AbstractMaxScoreKnnCollector;

class MaxScoreTopKnnCollector
extends AbstractMaxScoreKnnCollector {
    private long minCompetitiveDocScore = LEAST_COMPETITIVE;
    private float minCompetitiveSimilarity = Float.NEGATIVE_INFINITY;
    protected final NeighborQueue queue;

    MaxScoreTopKnnCollector(int k, long visitLimit, KnnSearchStrategy searchStrategy) {
        super(k, visitLimit, searchStrategy);
        this.queue = new NeighborQueue(k, false);
    }

    @Override
    public long getMinCompetitiveDocScore() {
        return this.queue.size() > 0 ? Math.max(this.minCompetitiveDocScore, this.queue.peek()) : this.minCompetitiveDocScore;
    }

    @Override
    void updateMinCompetitiveDocScore(long minCompetitiveDocScore) {
        long queueMinCompetitiveDocScore = this.queue.size() > 0 ? this.queue.peek() : LEAST_COMPETITIVE;
        this.minCompetitiveDocScore = Math.max(this.minCompetitiveDocScore, Math.max(queueMinCompetitiveDocScore, minCompetitiveDocScore));
        this.minCompetitiveSimilarity = NeighborQueue.decodeScoreRaw(this.minCompetitiveDocScore);
    }

    @Override
    public boolean collect(int docId, float similarity) {
        return this.queue.insertWithOverflow(docId, similarity);
    }

    @Override
    public int numCollected() {
        return this.queue.size();
    }

    @Override
    public float minCompetitiveSimilarity() {
        return this.queue.size() < this.k() ? Float.NEGATIVE_INFINITY : Math.max(this.minCompetitiveSimilarity, this.queue.topScore());
    }

    @Override
    public TopDocs topDocs() {
        assert (this.queue.size() <= this.k()) : "Tried to collect more results than the maximum number allowed";
        ScoreDoc[] scoreDocs = new ScoreDoc[this.queue.size()];
        for (int i = 1; i <= scoreDocs.length; ++i) {
            scoreDocs[scoreDocs.length - i] = new ScoreDoc(this.queue.topNode(), this.queue.topScore());
            this.queue.pop();
        }
        TotalHits.Relation relation = this.earlyTerminated() ? TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO : TotalHits.Relation.EQUAL_TO;
        return new TopDocs(new TotalHits(this.visitedCount(), relation), scoreDocs);
    }
}

