/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.runtime;

import java.util.Objects;
import org.elasticsearch.script.DoubleFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.runtime.AbstractDoubleScriptFieldQuery;

public class DoubleScriptFieldRangeQuery
extends AbstractDoubleScriptFieldQuery {
    private final double lowerValue;
    private final double upperValue;

    public DoubleScriptFieldRangeQuery(Script script, DoubleFieldScript.LeafFactory leafFactory, String fieldName, double lowerValue, double upperValue) {
        super(script, leafFactory, fieldName);
        this.lowerValue = lowerValue;
        this.upperValue = upperValue;
        assert (lowerValue <= upperValue);
    }

    @Override
    protected boolean matches(double[] values, int count) {
        for (int i = 0; i < count; ++i) {
            if (Double.compare(this.lowerValue, values[i]) > 0 || Double.compare(values[i], this.upperValue) > 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public final String toString(String field) {
        StringBuilder b = new StringBuilder();
        if (!this.fieldName().contentEquals(field)) {
            b.append(this.fieldName()).append(':');
        }
        b.append('[').append(this.lowerValue).append(" TO ").append(this.upperValue).append(']');
        return b.toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.lowerValue, this.upperValue);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        DoubleScriptFieldRangeQuery other = (DoubleScriptFieldRangeQuery)obj;
        return this.lowerValue == other.lowerValue && this.upperValue == other.upperValue;
    }

    double lowerValue() {
        return this.lowerValue;
    }

    double upperValue() {
        return this.upperValue;
    }
}

