/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.retriever;

import java.util.Objects;
import java.util.function.Predicate;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.search.retriever.RetrieverBuilder;
import org.elasticsearch.usage.SearchUsage;

public class RetrieverParserContext {
    protected final SearchUsage searchUsage;
    protected final Predicate<NodeFeature> clusterSupportsFeature;

    public RetrieverParserContext(SearchUsage searchUsage, Predicate<NodeFeature> clusterSupportsFeature) {
        this.searchUsage = Objects.requireNonNull(searchUsage);
        this.clusterSupportsFeature = clusterSupportsFeature;
    }

    public void trackSectionUsage(String section) {
        this.searchUsage.trackSectionUsage(section);
    }

    public void trackQueryUsage(String query) {
        this.searchUsage.trackQueryUsage(query);
    }

    public void trackRescorerUsage(String name) {
        this.searchUsage.trackRescorerUsage(name);
    }

    public void trackRetrieverUsage(RetrieverBuilder retriever) {
        this.searchUsage.trackRetrieverUsage(retriever.getName());
        this.searchUsage.trackRetrieverExtendedDataUsage(retriever.getName(), retriever.getExtendedUsageFields());
    }

    public boolean clusterSupportsFeature(NodeFeature nodeFeature) {
        return this.clusterSupportsFeature != null && this.clusterSupportsFeature.test(nodeFeature);
    }
}

