/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.SimpleRefCounted;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.internal.ShardSearchContextId;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.transport.LeakTracker;

public final class QueryFetchSearchResult
extends SearchPhaseResult {
    private final QuerySearchResult queryResult;
    private final FetchSearchResult fetchResult;
    private final RefCounted refCounted;

    public static QueryFetchSearchResult of(QuerySearchResult queryResult, FetchSearchResult fetchResult) {
        queryResult.incRef();
        fetchResult.incRef();
        return new QueryFetchSearchResult(queryResult, fetchResult);
    }

    public QueryFetchSearchResult(StreamInput in) throws IOException {
        this(new QuerySearchResult(in), new FetchSearchResult(in));
    }

    private QueryFetchSearchResult(QuerySearchResult queryResult, FetchSearchResult fetchResult) {
        this.queryResult = queryResult;
        this.fetchResult = fetchResult;
        this.refCounted = LeakTracker.wrap(new SimpleRefCounted());
    }

    @Override
    public ShardSearchContextId getContextId() {
        return this.queryResult.getContextId();
    }

    @Override
    public SearchShardTarget getSearchShardTarget() {
        return this.queryResult.getSearchShardTarget();
    }

    @Override
    public void setSearchShardTarget(SearchShardTarget shardTarget) {
        super.setSearchShardTarget(shardTarget);
        this.queryResult.setSearchShardTarget(shardTarget);
        this.fetchResult.setSearchShardTarget(shardTarget);
    }

    @Override
    public void setShardIndex(int requestIndex) {
        super.setShardIndex(requestIndex);
        this.queryResult.setShardIndex(requestIndex);
        this.fetchResult.setShardIndex(requestIndex);
    }

    @Override
    public QuerySearchResult queryResult() {
        return this.queryResult;
    }

    @Override
    public FetchSearchResult fetchResult() {
        return this.fetchResult;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.queryResult.writeTo(out);
        this.fetchResult.writeTo(out);
    }

    @Override
    public void incRef() {
        this.refCounted.incRef();
    }

    @Override
    public boolean tryIncRef() {
        return this.refCounted.tryIncRef();
    }

    @Override
    public boolean decRef() {
        if (this.refCounted.decRef()) {
            this.deallocate();
            return true;
        }
        return false;
    }

    private void deallocate() {
        this.queryResult.decRef();
        this.fetchResult.decRef();
    }

    @Override
    public boolean hasReferences() {
        return this.refCounted.hasReferences();
    }
}

