/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.fetch.FetchPhaseExecutionException;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.query.SearchTimeoutException;

abstract class FetchPhaseDocsIterator {
    FetchPhaseDocsIterator() {
    }

    protected abstract void setNextReader(LeafReaderContext var1, int[] var2) throws IOException;

    protected abstract SearchHit nextDoc(int var1) throws IOException;

    public final SearchHit[] iterate(SearchShardTarget shardTarget, IndexReader indexReader, int[] docIds, boolean allowPartialResults, QuerySearchResult querySearchResult) {
        SearchHit[] searchHits = new SearchHit[docIds.length];
        Object[] docs = new DocIdToIndex[docIds.length];
        for (int index = 0; index < docIds.length; ++index) {
            docs[index] = new DocIdToIndex(docIds[index], index);
        }
        Arrays.sort(docs);
        int currentDoc = ((DocIdToIndex)docs[0]).docId;
        try {
            int leafOrd = ReaderUtil.subIndex(((DocIdToIndex)docs[0]).docId, indexReader.leaves());
            LeafReaderContext ctx = indexReader.leaves().get(leafOrd);
            int endReaderIdx = FetchPhaseDocsIterator.endReaderIdx(ctx, 0, (DocIdToIndex[])docs);
            int[] docsInLeaf = FetchPhaseDocsIterator.docIdsInLeaf(0, endReaderIdx, (DocIdToIndex[])docs, ctx.docBase);
            try {
                this.setNextReader(ctx, docsInLeaf);
            }
            catch (ContextIndexSearcher.TimeExceededException e) {
                SearchTimeoutException.handleTimeout(allowPartialResults, shardTarget, querySearchResult);
                assert (allowPartialResults);
                return SearchHits.EMPTY;
            }
            for (int i = 0; i < docs.length; ++i) {
                try {
                    if (i >= endReaderIdx) {
                        leafOrd = ReaderUtil.subIndex(((DocIdToIndex)docs[i]).docId, indexReader.leaves());
                        ctx = indexReader.leaves().get(leafOrd);
                        endReaderIdx = FetchPhaseDocsIterator.endReaderIdx(ctx, i, (DocIdToIndex[])docs);
                        docsInLeaf = FetchPhaseDocsIterator.docIdsInLeaf(i, endReaderIdx, (DocIdToIndex[])docs, ctx.docBase);
                        this.setNextReader(ctx, docsInLeaf);
                    }
                    currentDoc = ((DocIdToIndex)docs[i]).docId;
                    assert (searchHits[((DocIdToIndex)docs[i]).index] == null);
                    searchHits[((DocIdToIndex)docs[i]).index] = this.nextDoc(((DocIdToIndex)docs[i]).docId);
                    continue;
                }
                catch (ContextIndexSearcher.TimeExceededException e) {
                    if (!allowPartialResults) {
                        FetchPhaseDocsIterator.purgeSearchHits(searchHits);
                    }
                    SearchTimeoutException.handleTimeout(allowPartialResults, shardTarget, querySearchResult);
                    assert (allowPartialResults);
                    SearchHit[] partialSearchHits = new SearchHit[i];
                    System.arraycopy(searchHits, 0, partialSearchHits, 0, i);
                    return partialSearchHits;
                }
            }
        }
        catch (SearchTimeoutException e) {
            throw e;
        }
        catch (CircuitBreakingException e) {
            FetchPhaseDocsIterator.purgeSearchHits(searchHits);
            throw e;
        }
        catch (Exception e) {
            FetchPhaseDocsIterator.purgeSearchHits(searchHits);
            throw new FetchPhaseExecutionException(shardTarget, "Error running fetch phase for doc [" + currentDoc + "]", e);
        }
        return searchHits;
    }

    private static void purgeSearchHits(SearchHit[] searchHits) {
        for (SearchHit searchHit : searchHits) {
            if (searchHit == null) continue;
            searchHit.decRef();
        }
    }

    private static int endReaderIdx(LeafReaderContext currentReaderContext, int index, DocIdToIndex[] docs) {
        int i;
        int firstInNextReader = currentReaderContext.docBase + currentReaderContext.reader().maxDoc();
        for (i = index + 1; i < docs.length; ++i) {
            if (docs[i].docId < firstInNextReader) continue;
            return i;
        }
        return i;
    }

    private static int[] docIdsInLeaf(int index, int endReaderIdx, DocIdToIndex[] docs, int docBase) {
        int[] result = new int[endReaderIdx - index];
        int d = 0;
        for (int i = index; i < endReaderIdx; ++i) {
            assert (docs[i].docId >= docBase);
            result[d++] = docs[i].docId - docBase;
        }
        return result;
    }

    private static class DocIdToIndex
    implements Comparable<DocIdToIndex> {
        final int docId;
        final int index;

        DocIdToIndex(int docId, int index) {
            this.docId = docId;
            this.index = index;
        }

        @Override
        public int compareTo(DocIdToIndex o) {
            return Integer.compare(this.docId, o.docId);
        }
    }
}

