/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field.vectors;

import java.util.Arrays;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.VectorUtil;
import org.elasticsearch.script.field.vectors.ByteRankVectors;
import org.elasticsearch.script.field.vectors.VectorIterator;
import org.elasticsearch.simdvec.ESVectorUtil;

public class BitRankVectors
extends ByteRankVectors {
    public BitRankVectors(VectorIterator<byte[]> vectorValues, BytesRef magnitudesBytes, int numVecs, int dims) {
        super(vectorValues, magnitudesBytes, numVecs, dims);
    }

    @Override
    public void checkDimensions(int qvDims) {
        if (qvDims != this.dims) {
            throw new IllegalArgumentException("The query vector has a different number of dimensions [" + qvDims * 8 + "] than the document vectors [" + this.dims * 8 + "].");
        }
    }

    @Override
    public float maxSimDotProduct(float[][] query) {
        this.vectorValues.reset();
        float[] maxes = new float[query.length];
        Arrays.fill(maxes, Float.NEGATIVE_INFINITY);
        while (this.vectorValues.hasNext()) {
            byte[] vv = (byte[])this.vectorValues.next();
            for (int i = 0; i < query.length; ++i) {
                maxes[i] = Math.max(maxes[i], ESVectorUtil.ipFloatBit((float[])query[i], (byte[])vv));
            }
        }
        float sums = 0.0f;
        for (float m : maxes) {
            sums += m;
        }
        return sums;
    }

    @Override
    public float maxSimDotProduct(byte[][] query) {
        this.vectorValues.reset();
        float[] maxes = new float[query.length];
        Arrays.fill(maxes, Float.NEGATIVE_INFINITY);
        if (query[0].length == this.dims) {
            while (this.vectorValues.hasNext()) {
                vv = (byte[])this.vectorValues.next();
                for (i = 0; i < query.length; ++i) {
                    maxes[i] = Math.max(maxes[i], (float)ESVectorUtil.andBitCount((byte[])query[i], (byte[])vv));
                }
            }
        } else {
            while (this.vectorValues.hasNext()) {
                vv = (byte[])this.vectorValues.next();
                for (i = 0; i < query.length; ++i) {
                    maxes[i] = Math.max(maxes[i], (float)ESVectorUtil.ipByteBit((byte[])query[i], (byte[])vv));
                }
            }
        }
        float sum = 0.0f;
        for (float m : maxes) {
            sum += m;
        }
        return sum;
    }

    @Override
    public float maxSimInvHamming(byte[][] query) {
        this.vectorValues.reset();
        int bitCount = this.getDims();
        float[] maxes = new float[query.length];
        Arrays.fill(maxes, Float.NEGATIVE_INFINITY);
        while (this.vectorValues.hasNext()) {
            byte[] vv = (byte[])this.vectorValues.next();
            for (int i = 0; i < query.length; ++i) {
                maxes[i] = Math.max(maxes[i], (float)(bitCount - VectorUtil.xorBitCount(vv, query[i])) / (float)bitCount);
            }
        }
        float sum = 0.0f;
        for (float m : maxes) {
            sum += m;
        }
        return sum;
    }

    @Override
    public int getDims() {
        return this.dims * 8;
    }
}

