/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.persistent;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.NodePersistentTasksExecutor;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasks;
import org.elasticsearch.persistent.PersistentTasksClusterService;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.persistent.PersistentTasksExecutorRegistry;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskAwareRequest;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class PersistentTasksNodeService
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(PersistentTasksNodeService.class);
    private final ThreadPool threadPool;
    private final Map<Long, AllocatedPersistentTask> runningTasks = new HashMap<Long, AllocatedPersistentTask>();
    private final PersistentTasksService persistentTasksService;
    private final PersistentTasksExecutorRegistry persistentTasksExecutorRegistry;
    private final TaskManager taskManager;
    private final NodePersistentTasksExecutor nodePersistentTasksExecutor;

    public PersistentTasksNodeService(ThreadPool threadPool, PersistentTasksService persistentTasksService, PersistentTasksExecutorRegistry persistentTasksExecutorRegistry, TaskManager taskManager, NodePersistentTasksExecutor nodePersistentTasksExecutor) {
        this.threadPool = threadPool;
        this.persistentTasksService = persistentTasksService;
        this.persistentTasksExecutorRegistry = persistentTasksExecutorRegistry;
        this.taskManager = taskManager;
        this.nodePersistentTasksExecutor = nodePersistentTasksExecutor;
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        if (PersistentTasksClusterService.persistentTasksChanged(event) || event.nodesChanged()) {
            List<Tuple<ProjectId, PersistentTasks>> tuplesOfProjectAndTasks = PersistentTasks.getAllTasks(event.state()).toList();
            String localNodeId = event.state().getNodes().getLocalNodeId();
            HashSet<Long> notVisitedTasks = new HashSet<Long>(this.runningTasks.keySet());
            if (!tuplesOfProjectAndTasks.isEmpty()) {
                for (Tuple<ProjectId, PersistentTasks> projectIdAndTasks : tuplesOfProjectAndTasks) {
                    ProjectId projectId = projectIdAndTasks.v1();
                    for (PersistentTasksCustomMetadata.PersistentTask<?> taskInProgress : projectIdAndTasks.v2().tasks()) {
                        if (!localNodeId.equals(taskInProgress.getExecutorNode())) continue;
                        Long allocationId = taskInProgress.getAllocationId();
                        AllocatedPersistentTask persistentTask = this.runningTasks.get(allocationId);
                        if (persistentTask == null) {
                            try {
                                this.startTask(projectId, taskInProgress);
                            }
                            catch (Exception e) {
                                logger.error("Unable to start allocated " + PersistentTasks.taskTypeString(projectId) + " task [" + taskInProgress.getTaskName() + "] with id [" + taskInProgress.getId() + "] and allocation id [" + taskInProgress.getAllocationId() + "]", (Throwable)e);
                            }
                            continue;
                        }
                        notVisitedTasks.remove(allocationId);
                    }
                }
            }
            for (Long id : notVisitedTasks) {
                AllocatedPersistentTask task = this.runningTasks.get(id);
                if (task.isCompleted()) {
                    logger.trace("Found {} persistent task [{}] with id [{}], allocation id [{}] and status [{}] - removing", (Object)PersistentTasks.taskTypeString(task.getProjectId()), (Object)task.getAction(), (Object)task.getPersistentTaskId(), (Object)task.getAllocationId(), (Object)task.getStatus());
                    this.runningTasks.remove(id);
                    continue;
                }
                logger.trace("Found unregistered {} persistent task [{}] with id [{}] and allocation id [{}] - cancelling", (Object)PersistentTasks.taskTypeString(task.getProjectId()), (Object)task.getAction(), (Object)task.getPersistentTaskId(), (Object)task.getAllocationId());
                this.cancelTask(id);
            }
        }
    }

    private <Params extends PersistentTaskParams> void startTask(@Nullable ProjectId projectId, PersistentTasksCustomMetadata.PersistentTask<Params> taskInProgress) {
        PersistentTasksExecutor executor = this.persistentTasksExecutorRegistry.getPersistentTaskExecutorSafe(taskInProgress.getTaskName());
        assert (projectId == null && executor.scope() == PersistentTasksExecutor.Scope.CLUSTER || projectId != null && executor.scope() == PersistentTasksExecutor.Scope.PROJECT) : "inconsistent project-id [" + String.valueOf(projectId) + "] and task scope [" + String.valueOf((Object)executor.scope()) + "]";
        PersistentTaskAwareRequest<Params> request = new PersistentTaskAwareRequest<Params>(taskInProgress, executor);
        try (ThreadContext.StoredContext ignored = this.threadPool.getThreadContext().newTraceContext();){
            if (projectId != null) {
                String projectIdString = projectId.id();
                this.threadPool.getThreadContext().putHeader("X-Elastic-Project-Id", projectIdString);
            }
            this.doStartTask(taskInProgress, executor, request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <Params extends PersistentTaskParams> void doStartTask(PersistentTasksCustomMetadata.PersistentTask<Params> taskInProgress, PersistentTasksExecutor<Params> executor, TaskAwareRequest request) {
        AllocatedPersistentTask task;
        try {
            task = (AllocatedPersistentTask)this.taskManager.register("persistent", taskInProgress.getTaskName() + "[c]", request);
        }
        catch (Exception e) {
            logger.error("Fatal error registering persistent task [" + taskInProgress.getTaskName() + "] with id [" + taskInProgress.getId() + "] and allocation id [" + taskInProgress.getAllocationId() + "], removing from persistent tasks", (Throwable)e);
            AllocatedPersistentTask placeholderTask = (AllocatedPersistentTask)this.taskManager.register("persistent", taskInProgress.getTaskName() + "[c]", new PersistentTaskAwareRequest<Params>(taskInProgress, new PersistentTaskStartupFailureExecutor(executor.getTaskName(), EsExecutors.DIRECT_EXECUTOR_SERVICE)));
            placeholderTask.init(this.persistentTasksService, this.taskManager, taskInProgress.getId(), taskInProgress.getAllocationId());
            this.taskManager.unregister(placeholderTask);
            this.runningTasks.put(taskInProgress.getAllocationId(), placeholderTask);
            placeholderTask.markAsFailed(e);
            return;
        }
        boolean processed = false;
        Exception initializationException = null;
        try {
            task.init(this.persistentTasksService, this.taskManager, taskInProgress.getId(), taskInProgress.getAllocationId());
            logger.trace("Persistent task [{}] with id [{}] and allocation id [{}] was created", (Object)task.getAction(), (Object)task.getPersistentTaskId(), (Object)task.getAllocationId());
            try {
                this.runningTasks.put(taskInProgress.getAllocationId(), task);
                this.nodePersistentTasksExecutor.executeTask(taskInProgress.getParams(), taskInProgress.getState(), task, executor);
            }
            catch (Exception e) {
                task.markAsFailed(e);
            }
            processed = true;
        }
        catch (Exception e) {
            initializationException = e;
        }
        finally {
            if (!processed) {
                logger.warn("Persistent task [{}] with id [{}] and allocation id [{}] failed to create", (Object)task.getAction(), (Object)task.getPersistentTaskId(), (Object)task.getAllocationId());
                this.taskManager.unregister(task);
                if (initializationException != null) {
                    this.notifyMasterOfFailedTask(taskInProgress, initializationException);
                }
            }
        }
    }

    private <Params extends PersistentTaskParams> void notifyMasterOfFailedTask(final PersistentTasksCustomMetadata.PersistentTask<Params> taskInProgress, final Exception originalException) {
        this.persistentTasksService.sendCompletionRequest(taskInProgress.getId(), taskInProgress.getAllocationId(), originalException, null, TimeValue.THIRTY_SECONDS, new ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>>(this){

            @Override
            public void onResponse(PersistentTasksCustomMetadata.PersistentTask<?> persistentTask) {
                logger.trace("completion notification for failed task [{}] with id [{}] was successful", (Object)taskInProgress.getTaskName(), (Object)taskInProgress.getAllocationId());
            }

            @Override
            public void onFailure(Exception notificationException) {
                notificationException.addSuppressed(originalException);
                logger.warn(() -> Strings.format("notification for task [%s] with id [%s] failed", taskInProgress.getTaskName(), taskInProgress.getAllocationId()), (Throwable)notificationException);
            }
        });
    }

    private void cancelTask(Long allocationId) {
        final AllocatedPersistentTask task = this.runningTasks.remove(allocationId);
        if (task.markAsCancelled()) {
            String reason = "task has been removed, cancelling locally";
            this.persistentTasksService.sendCancelRequest(task.getId(), reason, new ActionListener<ListTasksResponse>(this){

                @Override
                public void onResponse(ListTasksResponse cancelTasksResponse) {
                    logger.trace("Persistent {} task [{}] with id [{}] and allocation id [{}] was cancelled", (Object)PersistentTasks.taskTypeString(task.getProjectId()), (Object)task.getAction(), (Object)task.getPersistentTaskId(), (Object)task.getAllocationId());
                }

                @Override
                public void onFailure(Exception e) {
                    logger.warn(() -> Strings.format("failed to cancel {} task [%s] with id [%s] and allocation id [%s]", PersistentTasks.taskTypeString(task.getProjectId()), task.getAction(), task.getPersistentTaskId(), task.getAllocationId()), (Throwable)e);
                }
            });
        }
    }

    private static class PersistentTaskAwareRequest<Params extends PersistentTaskParams>
    implements TaskAwareRequest {
        private final PersistentTasksCustomMetadata.PersistentTask<Params> taskInProgress;
        private final TaskId parentTaskId;
        private final PersistentTasksExecutor<Params> executor;

        private PersistentTaskAwareRequest(PersistentTasksCustomMetadata.PersistentTask<Params> taskInProgress, PersistentTasksExecutor<Params> executor) {
            this.taskInProgress = taskInProgress;
            this.parentTaskId = new TaskId("cluster", taskInProgress.getAllocationId());
            this.executor = executor;
        }

        @Override
        public void setParentTask(TaskId taskId) {
            throw new UnsupportedOperationException("parent task if for persistent tasks shouldn't change");
        }

        @Override
        public void setRequestId(long requestId) {
            throw new UnsupportedOperationException("does not have a request ID");
        }

        @Override
        public TaskId getParentTask() {
            return this.parentTaskId;
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return this.executor.createTask(id, type, action, parentTaskId, this.taskInProgress, headers);
        }
    }

    private static class PersistentTaskStartupFailureExecutor<Params extends PersistentTaskParams>
    extends PersistentTasksExecutor<Params> {
        PersistentTaskStartupFailureExecutor(String taskName, Executor executor) {
            super(taskName, executor);
        }

        @Override
        protected void nodeOperation(AllocatedPersistentTask task, Params params, PersistentTaskState state) {
        }
    }

    public static class Status
    implements Task.Status {
        public static final String NAME = "persistent_executor";
        private final AllocatedPersistentTask.State state;

        public Status(AllocatedPersistentTask.State state) {
            this.state = Objects.requireNonNull(state, "State cannot be null");
        }

        public Status(StreamInput in) throws IOException {
            this.state = AllocatedPersistentTask.State.valueOf(in.readString());
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("state", this.state.toString());
            builder.endObject();
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.state.toString());
        }

        public String toString() {
            return org.elasticsearch.common.Strings.toString(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status)o;
            return this.state == status.state;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.state});
        }
    }
}

